/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogNameData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class DogNamePacket
extends DogPacket<DogNameData> {
    @Override
    public void encode(DogNameData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.m_130072_(data.name, Dog.MAX_NAME_LEN);
    }

    @Override
    public DogNameData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        String name = buf.m_130136_(Dog.MAX_NAME_LEN);
        return new DogNameData(entityId, name);
    }

    @Override
    public void handleDog(Dog dogIn, DogNameData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (data.name.isEmpty()) {
            dogIn.setDogCustomName(null);
        } else {
            dogIn.setDogCustomName((Component)Component.m_237113_((String)data.name));
        }
    }
}

