/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DogMigrateOwnerPacket
extends DogPacket<DogMigrateOwnerData> {
    @Override
    public void encode(DogMigrateOwnerData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.confirmed);
    }

    @Override
    public DogMigrateOwnerData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean confirmed = buf.readBoolean();
        return new DogMigrateOwnerData(id, confirmed);
    }

    @Override
    public void handleDog(Dog dog, DogMigrateOwnerData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41720_() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.m_36335_().m_41519_((Item)DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.m_20148_())) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (!tag.m_128403_("request_uuid")) {
            tag.m_128473_("request_str");
            return;
        }
        UUID uuid = tag.m_128342_("request_uuid");
        tag.m_128473_("request_uuid");
        tag.m_128473_("request_str");
        if (ownerUUID.equals(uuid)) {
            return;
        }
        Player requester = dog.m_9236_().m_46003_(uuid);
        if (requester == null) {
            return;
        }
        if (!data.confirmed) {
            requester.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.amnesia_bone.migrate_owner.reject", (Object[])new Object[]{dog.m_7755_().getString()}).m_130940_(ChatFormatting.RED));
            return;
        }
        if (sender.f_36078_ < AmnesiaBoneItem.getMigrateOwnerXPCost()) {
            return;
        }
        dog.migrateOwner(uuid);
        sender.m_6749_(-AmnesiaBoneItem.getMigrateOwnerXPCost());
        sender.m_36335_().m_41524_((Item)DoggyItems.AMNESIA_BONE.get(), 60);
        int usedTime = tag.m_128451_("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.m_41774_(1);
            sender.m_21166_(EquipmentSlot.MAINHAND);
        }
        tag.m_128405_("amnesia_bone_used_time", usedTime);
        requester.m_213846_((Component)Component.m_237110_((String)"item.doggytalents.amnesia_bone.migrate_owner.confirmed", (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderPronoun()}));
    }
}

