/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.common.util.NBTUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ScentTreatItem
extends Item {
    public static String SCENT_BLOCK_ID = "DTN_scented_block_id";

    public ScentTreatItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (this.handleClearScent(state, context).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleAddScent(state, context).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult handleClearScent(BlockState state, UseOnContext context) {
        if (!state.m_60713_(Blocks.f_152476_)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(SCENT_BLOCK_ID)) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        stack.m_41751_(new CompoundTag());
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleAddScent(BlockState state, UseOnContext context) {
        if (state.m_60713_(Blocks.f_152476_)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(SCENT_BLOCK_ID)) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Block block = state.m_60734_();
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        NBTUtil.putResourceLocation(tag, SCENT_BLOCK_ID, id);
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5671_(stack) + ".description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(SCENT_BLOCK_ID)) {
            return;
        }
        Block block = (Block)NBTUtil.getRegistryValue(tag, SCENT_BLOCK_ID, ForgeRegistries.BLOCKS);
        if (block == null) {
            return;
        }
        components.add((Component)Component.m_237115_((String)(this.m_5524_() + ".scented_block")));
        components.add((Component)Component.m_237115_((String)block.m_5456_().m_5524_()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }
}

