/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.ai.WolfBegAtTreatGoal;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogPlayTagAction;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.talent.HunterDogTalent;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.DogLocationStorageMigration;
import doggytalents.common.util.Util;
import doggytalents.common.util.dogpromise.DogPromiseManager;
import doggytalents.common.util.dogpromise.promise.DogBatchTeleportToDimensionPromise;
import doggytalents.common.util.dogpromise.promise.DogHoldChunkToTeleportPromise;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class EventHandler {
    public final int COLLECT_RADIUS = 26;
    public final int MIN_DISTANCE_TO_TRIGGER_TELEPORT_SQR = 400;

    @SubscribeEvent
    public void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        DogPromiseManager.tick();
        DogLocationStorage.get(event.getServer()).getOnlineDogsManager().tick();
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        DogPromiseManager.forceStop();
        DogLocationStorage.get(event.getServer()).onServerStop(event);
    }

    @SubscribeEvent
    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Player owner = event.getEntity();
        if (stack.m_41720_() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (target.m_6095_() != EntityType.f_20499_) {
            return;
        }
        if (!(target instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)target;
        event.setCanceled(true);
        if (!this.checkValidWolf(wolf, owner)) {
            event.setCancellationResult(InteractionResult.FAIL);
            return;
        }
        if (!level.f_46443_) {
            if (!owner.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.trainWolf(wolf, owner, level);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private boolean checkValidWolf(Wolf wolf, Player owner) {
        if (!wolf.m_6084_()) {
            return false;
        }
        boolean trainUntamed = (Boolean)ConfigHandler.SERVER.DISABLE_TRAIN_UNTAMED_WOLF.get() == false;
        boolean condition1 = trainUntamed && !wolf.m_21824_();
        boolean condition2 = wolf.m_21824_() && wolf.m_21830_((LivingEntity)owner);
        return condition1 || condition2;
    }

    private void trainWolf(Wolf wolf, Player owner, Level level) {
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_(level);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.m_21828_(owner);
        dog.m_21153_(dog.m_21233_());
        dog.m_21839_(false);
        dog.m_146762_(wolf.m_146764_());
        dog.m_19890_(wolf.m_20185_(), wolf.m_20186_(), wolf.m_20189_(), wolf.m_146908_(), wolf.m_146909_());
        dog.m_5616_(wolf.m_6080_());
        dog.m_5618_(wolf.m_213816_());
        DyeColor wolf_collar_color = wolf.m_30428_();
        int color = Util.srgbArrayToInt(wolf_collar_color.m_41068_());
        AccessoryInstance dog_collar = ((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        if (wolf.m_8077_()) {
            dog.setDogCustomName(wolf.m_7770_());
        }
        UUID wolf_uuid = wolf.m_20148_();
        wolf.m_146870_();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            this.migrateUUID(wolf_uuid, dog, sL);
        }
        level.m_7967_((Entity)dog);
        dog.triggerAnimationAction(new DogBackFlipAction(dog));
        dog.m_21569_().m_24901_();
    }

    private void migrateUUID(UUID uuid, Dog dog, ServerLevel level) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return;
        }
        if (level.m_8791_(uuid) != null) {
            return;
        }
        dog.m_20084_(uuid);
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            skeleton.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)skeleton, Dog.class, 6.0f, 1.0, 1.2));
        } else if (entity instanceof Wolf) {
            Wolf \u5927\u795e = (Wolf)entity;
            \u5927\u795e.f_21345_.m_25352_(9, (Goal)new WolfBegAtTreatGoal(\u5927\u795e, 8.0f));
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (this.isEnableStarterBundle()) {
            CompoundTag persistTag;
            Player player = event.getEntity();
            CompoundTag tag = player.getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("gotDTStartingItems")) {
                persistTag.m_128379_("gotDTStartingItems", true);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)DoggyItems.STARTER_BUNDLE.get()));
            }
        }
    }

    private boolean isEnableStarterBundle() {
        MutableBoolean retMut = new MutableBoolean(false);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.ENABLE_STARTER_BUNDLE_BY_DEFAULT)).booleanValue()) {
                retMut.setTrue();
            }
        });
        if (retMut.getValue().booleanValue()) {
            return true;
        }
        return (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.STARTING_ITEMS);
    }

    @SubscribeEvent
    public void onLootDrop(LootingLevelEvent event) {
        HunterDogTalent.onLootDrop(event);
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        Projectile levelChecker = event.getProjectile();
        if (levelChecker == null) {
            return;
        }
        Level level = levelChecker.m_9236_();
        if (level.f_46443_) {
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult hitEntity = (EntityHitResult)hitResult;
            this.proccessEntityProjectileHitEvent(event, hitEntity);
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitBlock = (BlockHitResult)hitResult;
            this.proccessBlockProjectileHitEvent(event, hitBlock);
        }
    }

    private void proccessEntityProjectileHitEvent(ProjectileImpactEvent event, EntityHitResult hit) {
        AbstractArrow arrow;
        Entity entity = hit.m_82443_();
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        Projectile projectile = event.getProjectile();
        Entity projectileOnwer = projectile.m_19749_();
        if (projectileOnwer == null) {
            return;
        }
        LivingEntity dogOwner = dog.m_269323_();
        if (projectile instanceof Snowball) {
            if (projectileOnwer == dogOwner && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PLAY_TAG_WITH_DOG)).booleanValue() && !dog.isBusy() && !dog.m_21827_()) {
                dog.triggerAction(new DogPlayTagAction(dog, dogOwner));
            }
            return;
        }
        boolean flag = EventHandler.checkIfArrowShouldNotHurtDog(dog, projectileOnwer, dogOwner);
        if (!flag) {
            return;
        }
        if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36796_() > 0) {
            arrow.m_36767_((byte)0);
        }
        event.setCanceled(true);
    }

    private void proccessBlockProjectileHitEvent(ProjectileImpactEvent event, BlockHitResult hit) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownEgg)) {
            return;
        }
        Level level = projectile.m_9236_();
        BlockPos pos = hit.m_82425_();
        Direction dir = hit.m_82434_();
        if (dir != Direction.UP) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_152476_)) {
            return;
        }
        BlockState state_under = level.m_8055_(pos.m_7495_());
        if (!WalkNodeEvaluator.m_77622_((BlockState)state_under)) {
            return;
        }
        ItemStack resultStack = new ItemStack((ItemLike)DoggyItems.ONSEN_TAMAGO.get());
        ItemEntity resultEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, resultStack);
        level.m_7967_((Entity)resultEntity);
        projectile.m_5496_(SoundEvents.f_12534_, 0.5f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
    }

    private static boolean checkIfArrowShouldNotHurtDog(Dog dog, Entity projectileOnwer, LivingEntity dogOwner) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && projectileOnwer instanceof Player) {
            return true;
        }
        return !dog.canOwnerAttack() && dog.checkIfAttackedFromOwnerOrTeam(dogOwner, projectileOnwer);
    }

    @SubscribeEvent
    public void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            this.onOwnerChangeDimension(event, owner);
        }
    }

    private void onOwnerChangeDimension(EntityTravelToDimensionEvent event, ServerPlayer owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        MinecraftServer mcServer = sLevel.m_7654_();
        ServerLevel fromLevel = sLevel;
        ServerLevel toLevel = mcServer.m_129880_(event.getDimension());
        if (fromLevel == toLevel) {
            return;
        }
        List crossOriginTpList = fromLevel.m_6443_(Dog.class, owner.m_20191_().m_82377_(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogPromiseManager.addPromiseWithOwnerAndStartImmediately(new DogBatchTeleportToDimensionPromise(crossOriginTpList, fromLevel, owner.m_20148_(), (ResourceKey<Level>)event.getDimension(), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner)), owner);
    }

    @SubscribeEvent
    public void onOwnerTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer owner = (ServerPlayer)entity;
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        if (this.distanceTooShortToTeleport(event.getPrev(), event.getTarget())) {
            return;
        }
        List crossOriginTpList = sLevel.m_6443_(Dog.class, owner.m_20191_().m_82377_(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (LivingEntity)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogPromiseManager.addPromiseWithOwnerAndStartImmediately(new DogHoldChunkToTeleportPromise(crossOriginTpList, sLevel), owner);
    }

    private boolean isDogReadyToTeleport(Dog dog, LivingEntity owner) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (owner == null || dog.m_21805_() == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)dog.m_21805_(), (Object)owner.m_20148_())) {
            return false;
        }
        if (dog.m_21827_()) {
            return false;
        }
        if (!dog.getMode().shouldFollowOwner()) {
            return false;
        }
        return dog.crossOriginTp();
    }

    private boolean distanceTooShortToTeleport(Vec3 from, Vec3 to) {
        return from.m_82557_(to) < 400.0;
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDropsEvent event) {
        PackPuppyTalent.mayNotifyNearbyPackPuppy(event);
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.onTagsUpdated(event);
    }

    @SubscribeEvent
    public void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level == null) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel level_overworld = server.m_129880_(Level.f_46428_);
        if (level != level_overworld) {
            return;
        }
        DogLocationStorageMigration.checkAndMigrate(level_overworld);
    }

    @SubscribeEvent
    public void onDogPassenegerHurtInWall(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!entity.m_20159_()) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.m_276093_(DamageTypes.f_268612_)) {
            return;
        }
        Entity vehicle = entity.m_20202_();
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        event.setAmount(0.0f);
        event.setCanceled(true);
    }
}

