/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.datasync;

import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogSyncData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class DogDataSyncManager {
    private final Dog dog;
    private final ArrayList<TalentInstance> talents = new ArrayList();
    private final ArrayList<AccessoryInstance> accessories = new ArrayList();
    private final ArrayList<TalentInstance> talentsNeedsRefresh = new ArrayList();
    private boolean talentsDirty = false;
    private boolean accessoriesDirty = false;

    public DogDataSyncManager(Dog dog) {
        this.dog = dog;
    }

    public ArrayList<TalentInstance> talents() {
        return this.talents;
    }

    public ArrayList<AccessoryInstance> accessories() {
        return this.accessories;
    }

    public void setTalentsDirty() {
        this.talentsDirty = true;
        this.dog.onTalentsUpdated();
    }

    public void setAccessoriesDirty() {
        this.accessoriesDirty = true;
        this.dog.onAccessoriesUpdated();
    }

    public void markTalentNeedRefresh(TalentInstance inst) {
        this.talentsNeedsRefresh.add(inst);
    }

    public void tick() {
        if (this.accessoriesDirty || this.talentsDirty || !this.talentsNeedsRefresh.isEmpty()) {
            this.broadcastChangesToClients();
        }
    }

    public void onStartBeingSeenBy(ServerPlayer seenBy) {
        this.sendAllDataTo(seenBy);
    }

    private void sendAllDataTo(ServerPlayer seenBy) {
        PacketHandler.send(PacketDistributor.PLAYER.with(() -> seenBy), new DogSyncData(this.dog.m_19879_(), this.talents(), this.accessories(), null));
    }

    private void broadcastChangesToClients() {
        ArrayList<AccessoryInstance> accessories = null;
        ArrayList<TalentInstance> talents = null;
        ArrayList<TalentInstance> needRefresh = null;
        if (this.accessoriesDirty) {
            this.accessoriesDirty = false;
            accessories = new ArrayList<AccessoryInstance>(this.accessories());
        }
        if (this.talentsDirty) {
            this.talentsDirty = false;
            talents = new ArrayList<TalentInstance>(this.talents());
            this.talentsNeedsRefresh.clear();
        }
        if (!this.talentsNeedsRefresh.isEmpty()) {
            needRefresh = new ArrayList<TalentInstance>(this.talentsNeedsRefresh);
            this.talentsNeedsRefresh.clear();
        }
        PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), new DogSyncData(this.dog.m_19879_(), talents, accessories, needRefresh));
    }

    public void updateFromDataPacketFromServer(DogSyncData data) {
        Optional<ArrayList<TalentInstance>> refreshOptions;
        Optional<ArrayList<TalentInstance>> talents;
        Optional<ArrayList<AccessoryInstance>> accessories = data.accessories();
        if (accessories.isPresent()) {
            this.accessories.clear();
            this.accessories.addAll((Collection<AccessoryInstance>)accessories.get());
            this.dog.onAccessoriesUpdated();
        }
        if ((talents = data.talents()).isPresent()) {
            this.talents.clear();
            this.talents.addAll((Collection<TalentInstance>)talents.get());
            this.dog.onTalentsUpdated();
        }
        if ((refreshOptions = data.refreshOptions()).isPresent()) {
            for (TalentInstance inst : refreshOptions.get()) {
                Talent talent = inst.getTalent();
                Optional<TalentInstance> dogInst = this.dog.getTalent(talent);
                if (!dogInst.isPresent()) continue;
                dogInst.get().updateOptionsFromServer(inst);
            }
        }
    }
}

