/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.anim;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.entity.anim.DogAnimationState;
import net.minecraft.util.Mth;

public class DogAnimationManager {
    private static final int SYNC_INTERVAL_TICK = 7;
    private static final int MIN_VAL_MAX_LATENCY = 7;
    public final DogAnimationState animationState = new DogAnimationState();
    public boolean needRefresh = false;
    private boolean started = false;
    private int animationTime;
    private final Dog dog;
    private boolean looping = false;
    private int tickTillSync = 0;

    public DogAnimationManager(Dog dog) {
        this.dog = dog;
    }

    public void onAnimationChange(DogAnimation anim) {
        this.animationTime = 0;
        if (anim != DogAnimation.NONE) {
            this.started = true;
            this.looping = anim.looping();
            this.animationTime = anim.getLengthTicks();
            this.animationState.start(this.dog.f_19797_);
            this.tickTillSync = 7;
        } else {
            this.started = false;
            this.looping = false;
            this.animationState.stop();
            if (this.dog.m_9236_().f_46443_) {
                this.needRefresh = true;
            }
        }
    }

    public void tick() {
        if (this.started && !this.dog.getAnim().freeHead()) {
            this.dog.f_19860_ = 0.0f;
            this.dog.f_20883_ = this.dog.f_20885_;
            this.dog.m_146926_(0.0f);
            this.dog.resetBeggingRotation();
        }
        if (this.started && !this.dog.m_9236_().f_46443_ && !this.looping) {
            if (this.animationTime <= 0) {
                this.animationTime = 0;
                this.dog.setAnim(DogAnimation.NONE);
            } else {
                if (--this.tickTillSync <= 0) {
                    this.tickTillSync = 7;
                    this.dog.setAnimSyncTime(this.animationTime);
                }
                --this.animationTime;
            }
        }
        if (this.started && this.dog.m_9236_().f_46443_ && !this.looping) {
            this.animationTime = this.animationTime <= 0 ? 0 : --this.animationTime;
        }
    }

    public void onSyncTimeUpdated() {
        if (this.dog.m_9236_().f_46443_) {
            this.resolveLatencyIfNeeded();
        }
    }

    private void resolveLatencyIfNeeded() {
        int currentTime;
        int correctTime;
        int latencyAbs;
        if (!this.started || this.looping) {
            return;
        }
        int configMaxLatency = (Integer)ConfigHandler.CLIENT.MAX_ANIMATION_LATENCY_ALLOWED.get();
        if (configMaxLatency < 0) {
            return;
        }
        int maxLatencyAllowed = 7;
        if (configMaxLatency > 7) {
            maxLatencyAllowed = configMaxLatency;
        }
        if ((latencyAbs = Mth.m_14040_((int)((correctTime = this.dog.getAnimSyncTime()) - (currentTime = this.animationTime)))) <= maxLatencyAllowed) {
            return;
        }
        DogAnimation anim = this.dog.getAnim();
        this.animationTime = Mth.m_14045_((int)correctTime, (int)0, (int)anim.getLengthTicks());
        int correctPassedTime = anim.getLengthTicks() - this.animationTime;
        this.animationState.resolveLatency(this.dog.f_19797_, correctPassedTime, anim.getSpeedModifier());
    }

    public boolean started() {
        return this.started;
    }
}

