/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimation;

public class AnimationAction
extends TriggerableAction {
    protected DogAnimation anim;
    protected int tickAnim;

    public AnimationAction(Dog dog, DogAnimation animation) {
        super(dog, false, false);
        this.anim = animation;
    }

    @Override
    public void onStart() {
        this.dog.setAnim(this.anim);
        if (!this.validateAnim()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void tick() {
        if (this.tickAnim >= this.anim.getLengthTicks()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.validateAnim()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        ++this.tickAnim;
    }

    @Override
    public void onStop() {
        if (this.dog.getAnim() == this.anim) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public boolean validateAnim() {
        if (this.dog.getAnim() != this.anim) {
            return false;
        }
        return this.dog.m_21573_().m_26571_();
    }

    public boolean blockMove() {
        return false;
    }

    public boolean blockLook() {
        return false;
    }

    public boolean blockSitStandAnim() {
        return false;
    }
}

