/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogRestWhenSitGoal
extends Goal {
    private Dog dog;
    private int restPeriod;
    private int reSitTime;
    private boolean isBellyUpRest;

    public DogRestWhenSitGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.m_6060_()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        return this.dog.wantsToRest();
    }

    public boolean m_8045_() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.m_21825_()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        return this.reSitTime <= this.getEndAnim().getLengthTicks();
    }

    public void m_8056_() {
        this.isBellyUpRest = this.dog.m_217043_().m_188503_(3) == 0;
        this.restPeriod = this.isBellyUpRest ? this.getStartAnim().getLengthTicks() + (1 + this.dog.m_217043_().m_188503_(4)) * this.getLoopAnim().getLengthTicks() : 100 + this.dog.m_217043_().m_188503_(11) * 20;
        this.reSitTime = 0;
        this.dog.setDogRestingState(this.isBellyUpRest ? Dog.RestingState.BELLY : Dog.RestingState.LYING);
        this.dog.setAnimForIdle(this.getStartAnim());
    }

    public void m_8037_() {
        if (this.restPeriod > 0) {
            if (this.dog.getAnim() == DogAnimation.NONE && this.dog.getDogPose() == this.getRestingPose()) {
                this.dog.setAnim(this.getLoopAnim());
            }
            --this.restPeriod;
        }
        if (this.restPeriod <= 0) {
            if (this.dog.getAnim() == this.getLoopAnim()) {
                this.dog.setAnim(this.getEndAnim());
            }
            this.dog.setDogRestingState(Dog.RestingState.NONE);
            ++this.reSitTime;
        }
    }

    public void m_8041_() {
        this.dog.resetTickTillRest();
        this.dog.setDogRestingState(Dog.RestingState.NONE);
        if (this.dog.getAnim() == this.getLoopAnim()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private DogAnimation getStartAnim() {
        return this.isBellyUpRest ? DogAnimation.REST_BELLY_START : DogAnimation.SIT_TO_REST;
    }

    private DogAnimation getLoopAnim() {
        return this.isBellyUpRest ? DogAnimation.REST_BELLY_LOOP : DogAnimation.REST_IDLE;
    }

    private DogAnimation getEndAnim() {
        return this.isBellyUpRest ? DogAnimation.REST_BELLY_END : DogAnimation.REST_TO_SIT;
    }

    private DogPose getRestingPose() {
        return this.isBellyUpRest ? DogPose.REST_BELLY : DogPose.REST;
    }
}

