/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.DogWrappedGoal;
import doggytalents.common.entity.anim.DogAnimation;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DogRandomSniffGoal
extends Goal
implements DogWrappedGoal.HasTickNonRunningPrev {
    private Dog dog;
    private int stopTick;
    private BlockPos sniffAtPos;
    private BlockPos sniffUnderPos;
    private BlockState sniffAtState;
    private BlockState sniffUnderState;
    private BlockPos currentPos;
    private DogAnimation currentAnimation = DogAnimation.NONE;
    private int tickAnim = 0;
    private boolean isDoingAnim = false;
    private boolean shouldMoveSignificantly = false;
    private final int EXPLORE_RADIUS = 6;
    private int stillRememberBeingBurnedTick = 0;

    public DogRandomSniffGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.m_6060_()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        return !(this.dog.m_217043_().m_188501_() >= 0.01f);
    }

    @Override
    public void tickDogWhenGoalNotRunning() {
        if (this.stillRememberBeingBurnedTick > 0) {
            --this.stillRememberBeingBurnedTick;
        }
    }

    public boolean m_8045_() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.isDoingAnim) {
            return true;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != this.currentAnimation) {
            return false;
        }
        this.validateSniff();
        if (this.sniffAtPos == null) {
            return false;
        }
        return this.dog.f_19797_ < this.stopTick;
    }

    public void m_8056_() {
        this.isDoingAnim = false;
        BlockPos moveToPos = this.findMoveToPos();
        this.dog.m_21573_().m_26519_((double)moveToPos.m_123341_(), (double)moveToPos.m_123342_(), (double)moveToPos.m_123343_(), 1.0);
        this.dog.setDogCurious(true);
    }

    public void m_8037_() {
        if (this.isDoingAnim) {
            this.tickDoingAnim();
        } else {
            this.tickMoveTo();
        }
    }

    public void m_8041_() {
        if (this.dog.getAnim() == this.currentAnimation && this.currentAnimation != DogAnimation.NONE) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.setDogCurious(false);
        this.resetSniffPos();
        this.dog.m_21573_().m_26573_();
    }

    private void startDoingAnim() {
        this.currentAnimation = this.getSniffAnim();
        this.stopTick = this.dog.f_19797_ + this.currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(this.currentAnimation);
        this.tickAnim = 0;
    }

    private void tickDoingAnim() {
        if (this.sniffAtPos == null) {
            return;
        }
        this.dog.m_21563_().m_24964_(Vec3.m_82539_((Vec3i)this.sniffAtPos));
        switch (this.currentAnimation) {
            default: {
                break;
            }
            case SNIFF_HOT: {
                float maxAwayDist = this.shouldMoveSignificantly ? 0.35f : 0.1f;
                Vec3 current_center = Vec3.m_82539_((Vec3i)this.currentPos);
                double d_sqr = this.dog.m_20238_(current_center);
                double d_sqr_2 = this.dog.m_20275_((float)this.sniffAtPos.m_123341_() + 0.5f, this.dog.m_20186_(), (float)this.sniffAtPos.m_123343_() + 0.5f);
                if (this.tickAnim < 20 && (d_sqr < (double)maxAwayDist || d_sqr_2 > 1.0) && this.sniffAtState.m_60795_()) {
                    this.dog.m_21566_().m_6849_((double)this.sniffAtPos.m_123341_(), this.dog.m_20186_(), (double)this.sniffAtPos.m_123343_(), 0.5);
                }
                if (this.tickAnim == 25) {
                    Vec3 pushBackVec = current_center.m_82546_(this.dog.m_20182_()).m_82541_();
                    this.dog.m_5997_(pushBackVec.m_7096_() * 0.3, 0.0, pushBackVec.m_7094_() * 0.3);
                    this.dog.m_5496_(SoundEvents.f_12621_, 0.6f, this.dog.m_6100_());
                    this.dog.m_5496_(SoundEvents.f_11909_, 0.3f, 2.0f + this.dog.m_217043_().m_188501_() * 0.4f);
                    this.rememberBeingBurned();
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_SNEEZE: {
                if (this.tickAnim == 25) {
                    this.dog.m_5496_(SoundEvents.f_12617_, 1.0f, (this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_()) * 0.2f + 1.5f);
                }
                ++this.tickAnim;
                break;
            }
            case TOUCHY_TOUCH: {
                if (this.tickAnim == 35) {
                    this.dog.m_5496_(SoundEvents.f_12621_, 0.6f, this.dog.m_6100_());
                    this.dog.m_5496_(SoundEvents.f_11909_, 0.3f, 2.0f + this.dog.m_217043_().m_188501_() * 0.4f);
                    this.rememberBeingBurned();
                }
                ++this.tickAnim;
            }
            case DOWN_THE_HOLE: {
                float maxAwayDist = 0.1f;
                Vec3 current_center = Vec3.m_82539_((Vec3i)this.currentPos);
                double d_sqr = this.dog.m_20238_(current_center);
                double d_sqr_2 = this.dog.m_20275_((float)this.sniffAtPos.m_123341_() + 0.5f, this.dog.m_20186_(), (float)this.sniffAtPos.m_123343_() + 0.5f);
                if (!(d_sqr < (double)maxAwayDist) && !(d_sqr_2 > 1.0) || !this.sniffAtState.m_60795_()) break;
                this.dog.m_21566_().m_6849_((double)this.sniffAtPos.m_123341_(), this.dog.m_20186_(), (double)this.sniffAtPos.m_123343_(), 0.5);
            }
        }
    }

    private void tickMoveTo() {
        if (this.dog.m_21573_().m_26571_()) {
            this.isDoingAnim = true;
            if (!this.dog.m_20096_()) {
                return;
            }
            this.findSniffPos();
            if (this.sniffAtPos != null) {
                this.startDoingAnim();
            }
        }
    }

    private BlockPos findMoveToPos() {
        RandomSource r = this.dog.m_217043_();
        int offX = r.m_216332_(-6, 6);
        int offY = r.m_216332_(-1, 1);
        int offZ = r.m_216332_(-6, 6);
        return this.dog.m_20183_().m_7918_(offX, offY, offZ);
    }

    private boolean findSniffPos() {
        BlockState sniffStateUnder;
        BlockState sniffState;
        int offset = this.dog.m_217043_().m_188499_() ? 1 : -1;
        boolean offsetX = this.dog.m_217043_().m_188499_();
        BlockPos currentPos = this.dog.m_20183_();
        BlockPos sniffPos = offsetX ? currentPos.m_7918_(offset, 0, 0) : currentPos.m_7918_(0, 0, offset);
        if (!this.isBlockSniffable(sniffPos, sniffState = this.dog.m_9236_().m_8055_(sniffPos))) {
            return false;
        }
        BlockPos sniffPosUnder = sniffPos.m_7495_();
        if (!this.isBlockBelowSniffable(sniffPosUnder, sniffStateUnder = this.dog.m_9236_().m_8055_(sniffPosUnder))) {
            return false;
        }
        this.populateSniffPos(currentPos, sniffPos, sniffState, sniffPosUnder, sniffStateUnder);
        return true;
    }

    private boolean isBlockSniffable(BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (this.stillRememberBeingBurned() && WalkNodeEvaluator.m_77622_((BlockState)state)) {
            return false;
        }
        return !state.m_60838_((BlockGetter)this.dog.m_9236_(), pos);
    }

    private boolean isBlockBelowSniffable(BlockPos posBelow, BlockState state) {
        return !this.stillRememberBeingBurned() || !WalkNodeEvaluator.m_77622_((BlockState)state);
    }

    private DogAnimation getSniffAnim() {
        boolean fireImmune = this.dog.m_5825_();
        boolean bl = this.shouldMoveSignificantly = !this.sniffUnderState.m_60838_((BlockGetter)this.dog.m_9236_(), this.sniffUnderPos);
        if (!fireImmune && WalkNodeEvaluator.m_77622_((BlockState)this.sniffUnderState) && this.sniffAtState.m_60795_()) {
            return DogAnimation.SNIFF_HOT;
        }
        Block atBlock = this.sniffAtState.m_60734_();
        if (atBlock instanceof FlowerBlock || atBlock instanceof TorchBlock) {
            return DogAnimation.SNIFF_SNEEZE;
        }
        if (!fireImmune && WalkNodeEvaluator.m_77622_((BlockState)this.sniffAtState)) {
            return DogAnimation.TOUCHY_TOUCH;
        }
        if (this.sniffAtState.m_60795_() && this.sniffUnderState.m_60795_()) {
            return DogAnimation.DOWN_THE_HOLE;
        }
        if (fireImmune && atBlock == Blocks.f_49991_) {
            return DogAnimation.SNIFF_SNEEZE;
        }
        return DogAnimation.SNIFF_NEUTRAL;
    }

    private void validateSniff() {
        BlockState newUnderState;
        BlockState newAtState;
        boolean invalidated = false;
        if (this.sniffAtPos == null) {
            invalidated = true;
        }
        if (!invalidated && (newAtState = this.dog.m_9236_().m_8055_(this.sniffAtPos)).m_60734_() != this.sniffAtState.m_60734_()) {
            invalidated = true;
        }
        if (!invalidated && (newUnderState = this.dog.m_9236_().m_8055_(this.sniffUnderPos)).m_60734_() != this.sniffUnderState.m_60734_()) {
            invalidated = true;
        }
        if (invalidated) {
            this.resetSniffPos();
            return;
        }
    }

    private void populateSniffPos(BlockPos current, BlockPos sniffPos, BlockState sniffState, BlockPos sniffUnderPos, BlockState sniffUnderState) {
        if (sniffUnderPos == null || sniffUnderState == null || sniffState == null || current == null) {
            sniffPos = null;
        }
        this.sniffAtState = sniffState;
        this.sniffUnderState = sniffUnderState;
        this.sniffAtPos = sniffPos;
        this.sniffUnderPos = sniffUnderPos;
        this.currentPos = current;
    }

    private void resetSniffPos() {
        this.sniffAtPos = null;
        this.sniffAtState = null;
        this.sniffUnderPos = null;
        this.sniffUnderState = null;
        this.currentPos = null;
    }

    private void rememberBeingBurned() {
        this.stillRememberBeingBurnedTick = this.dog.m_217043_().m_188503_(5) * 10 * 20;
    }

    private boolean stillRememberBeingBurned() {
        return this.stillRememberBeingBurnedTick > 0;
    }

    public boolean m_183429_() {
        return true;
    }
}

