/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class DogHungryGoal
extends Goal {
    private final Dog dog;
    private final Level world;
    private final double followSpeed;
    private final float stopDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;
    private int looktime;
    private int remindtime;

    public DogHungryGoal(Dog dog, double speedIn, float minDistIn) {
        this.dog = dog;
        this.world = dog.m_9236_();
        this.followSpeed = speedIn;
        this.stopDist = 3.0f;
        this.looktime = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.remindtime > 0) {
            this.remindtime = !this.dog.isLowHunger() ? 0 : --this.remindtime;
        }
        if (!this.dog.isDoingFine()) {
            return false;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null || this.remindtime > 0) {
            return false;
        }
        if (!this.dog.isLowHunger()) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.dog.m_21825_()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        return this.looktime <= 60 && this.dog.isLowHunger();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
        this.dog.setDogFollowingSomeone(true);
        this.looktime = 0;
    }

    public void m_8041_() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.m_20280_((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.m_5552_(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.f_41583_);
        }
        this.owner = null;
        this.dog.m_21573_().m_26573_();
        this.dog.setDogFollowingSomeone(false);
        this.dog.setBegging(false);
        this.remindtime = 200 + this.dog.m_217043_().m_188503_(40) * 20;
    }

    public void m_8037_() {
        if (this.dog.m_20280_((Entity)this.owner) > (double)this.stopDist) {
            this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, true, --this.tickTillSearchForTp <= 0, 400.0, this.dog.m_6056_());
                if (this.tickTillSearchForTp <= 0) {
                    this.tickTillSearchForTp = 10;
                }
            }
        } else {
            this.dog.setBegging(true);
            if (this.looktime == 0) {
                this.owner.m_213846_((Component)Component.m_237110_((String)("dog.msg.low_hunger." + this.dog.m_217043_().m_188503_(5)), (Object[])new Object[]{this.dog.m_7755_()}));
                this.dog.m_5496_(SoundEvents.f_12625_, this.dog.m_6121_(), this.dog.m_6100_());
            }
            this.dog.m_21563_().m_148051_((Entity)this.owner);
            ++this.looktime;
        }
    }
}

