/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.DogGreedyFireSafeSearchPath;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogGoAwayFromFireGoal
extends Goal {
    private Dog dog;
    private int tickUntilSearch;
    private DogGreedyFireSafeSearchPath path;

    public DogGoAwayFromFireGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.dog.m_5825_()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        int dangerSpot = -1;
        if (--this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 3;
            dangerSpot = this.isDogInDangerSpot(this.dog.m_20182_());
        }
        if (dangerSpot == -1) {
            return false;
        }
        this.path = DogGreedyFireSafeSearchPath.create(this.dog, 10);
        if (this.path == null) {
            this.tickUntilSearch = 10;
            return false;
        }
        return true;
    }

    public boolean m_8045_() {
        if (this.isSafePos(this.dog.m_20183_())) {
            return false;
        }
        return !this.dog.m_21573_().m_26571_();
    }

    public void m_8056_() {
        if (this.path == null) {
            return;
        }
        PathNavigation n = this.dog.m_21573_();
        n.m_26536_((Path)null, 1.0);
        n.m_26536_((Path)this.path, (double)this.dog.getUrgentSpeedModifier());
        if (this.path == null) {
            return;
        }
        BlockPos b0 = this.path.m_77375_(0).m_77288_();
        this.dog.m_21566_().m_6849_((double)((float)b0.m_123341_() + 0.5f), (double)b0.m_123342_(), (double)((float)b0.m_123343_() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
    }

    public void m_8041_() {
        if (this.path == null) {
            return;
        }
        Node end_node = this.path.m_77395_();
        if (end_node == null) {
            return;
        }
        BlockPos b0 = end_node.m_77288_();
        this.dog.m_21566_().m_6849_((double)((float)b0.m_123341_() + 0.5f), (double)b0.m_123342_(), (double)((float)b0.m_123343_() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        this.dog.m_21573_().m_26573_();
        if (end_node.f_77282_ != BlockPathTypes.WALKABLE) {
            this.tickUntilSearch = 20 + this.dog.m_217043_().m_188503_(3) * 10;
        }
    }

    private byte isDogInDangerSpot(Vec3 pos) {
        double FLUID_BB_DEFLATE = 0.001;
        double half_bbw = 0.5 * (double)this.dog.m_20205_() - 0.001;
        int minX = Mth.m_14107_((double)(pos.f_82479_ - half_bbw)) - 1;
        int minY = Mth.m_14107_((double)pos.f_82480_);
        int minZ = Mth.m_14107_((double)(pos.f_82481_ - half_bbw)) - 1;
        int maxX = Mth.m_14107_((double)(pos.f_82479_ + half_bbw)) + 1;
        int maxY = Mth.m_14107_((double)(pos.f_82480_ + 1.0));
        int maxZ = Mth.m_14107_((double)(pos.f_82481_ + half_bbw)) + 1;
        byte ret = -1;
        for (BlockPos x : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            boolean isWithinDogBb;
            boolean isCorner = !(x.m_123341_() != minX && x.m_123341_() != maxX || x.m_123343_() != minZ && x.m_123343_() != maxZ);
            if (isCorner || (isWithinDogBb = this.dog.m_20191_().m_82381_(new AABB(x)))) continue;
            BlockState state = this.dog.m_9236_().m_8055_(x);
            boolean isBurning = WalkNodeEvaluator.m_77622_((BlockState)state);
            if (state.m_60713_(Blocks.f_49991_)) {
                return 1;
            }
            AABB blockBb = new AABB(Vec3.m_82528_((Vec3i)x), Vec3.m_272021_((Vec3i)x, (double)1.0, (double)1.0, (double)1.0));
            if (!isBurning || !this.dog.m_20191_().m_82381_(blockBb)) continue;
            return 1;
        }
        return ret;
    }

    private boolean isSafePos(BlockPos pos) {
        BlockPathTypes blockType = WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        return blockType == BlockPathTypes.WALKABLE;
    }

    public boolean m_183429_() {
        return true;
    }
}

