/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class DogFeelingNakeyGoal
extends Goal {
    private Dog dog;
    private boolean prevNaked = true;
    private boolean turnedNaked = false;
    private int updateInterval = 60;
    private int lastUpdateTick;
    private int stopTick;
    private int tickAnim;

    public DogFeelingNakeyGoal(Dog dog) {
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.dog = dog;
    }

    public boolean m_8036_() {
        this.findOutIfTurningToNakid();
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        return this.turnedNaked && this.isNaked(this.dog);
    }

    public boolean m_8045_() {
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (!this.isNaked(this.dog)) {
            return false;
        }
        return this.dog.f_19797_ < this.stopTick;
    }

    public void m_8056_() {
        this.turnedNaked = false;
        DogAnimation currentAnimation = DogAnimation.NAKEY;
        this.stopTick = this.dog.f_19797_ + currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(currentAnimation);
        this.tickAnim = 0;
    }

    public void m_8037_() {
        if (this.tickAnim == 67) {
            this.dog.m_5496_(SoundEvents.f_12625_, this.dog.m_6121_(), this.dog.m_6100_());
        }
        ++this.tickAnim;
    }

    public void m_8041_() {
        if (this.dog.getAnim() == DogAnimation.NAKEY) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private void findOutIfTurningToNakid() {
        int updateAtTick = this.lastUpdateTick + this.updateInterval;
        if (this.dog.f_19797_ < updateAtTick) {
            return;
        }
        this.lastUpdateTick = this.dog.f_19797_;
        boolean naked = this.isNaked(this.dog);
        if (!naked) {
            this.turnedNaked = false;
        }
        if (naked && !this.prevNaked) {
            this.turnedNaked = this.dog.m_217043_().m_188501_() <= 0.9f;
        }
        this.updateInterval = naked ? (5 + this.dog.m_217043_().m_188503_(21)) * 20 : (1 + this.dog.m_217043_().m_188503_(3)) * 20;
        this.prevNaked = naked;
    }

    private boolean isNaked(Dog dog) {
        List<AccessoryInstance> accessories;
        if (!dog.hideArmor()) {
            Iterable<ItemStack> armors = dog.m_6168_();
            boolean hasArmor = false;
            for (ItemStack s : armors) {
                if (s.m_41619_()) continue;
                hasArmor = true;
                break;
            }
            if (hasArmor) {
                return false;
            }
        }
        if ((accessories = dog.getAccessories()).isEmpty()) {
            return true;
        }
        boolean hasNonNaked = false;
        for (AccessoryInstance x : accessories) {
            Accessory accessory = x.getAccessory();
            if (accessory.isDogStillNakedWhenWear()) continue;
            hasNonNaked = true;
            break;
        }
        return !hasNonNaked;
    }

    public boolean m_183429_() {
        return true;
    }
}

