/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import com.google.common.collect.Maps;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

public class DivineRetribution
extends Accessory
implements IAccessoryHasModel {
    public DivineRetribution(Supplier<? extends ItemLike> itemIn) {
        super((Supplier<? extends AccessoryType>)DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.DIVINE_RETRIB;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this);
    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public static final int MAX_COOKED = 10;
        public static final int COOK_RADIUS = 1;
        private final Map<ItemEntity, Integer> cooking = Maps.newHashMap();
        private int tickTillRefresh = 0;

        public Inst(Accessory typeIn) {
            super(typeIn);
        }

        @Override
        public void tick(AbstractDog dogIn) {
            if (!dogIn.isDoingFine()) {
                return;
            }
            if (--this.tickTillRefresh <= 0) {
                this.tickTillRefresh = 5;
                this.populateCooking(dogIn);
            }
            this.invalidateCooking(dogIn);
            this.cookAllCooking(dogIn);
            if (dogIn.m_9236_().f_46443_) {
                if (dogIn instanceof Dog) {
                    Dog dog = (Dog)dogIn;
                    this.addFlameParticles(dog);
                }
                this.playSizzleSound(dogIn);
            }
        }

        private void addFlameParticles(Dog dog) {
            float offsetY = 0.24f;
            DogPose pose = dog.getDogPose();
            if (pose == DogPose.STAND || pose == DogPose.FLYING) {
                offsetY += dog.getDogVisualBbHeight();
            }
            float a1 = dog.getClientAnimatedYBodyRotInRadians();
            float dx1 = -Mth.m_14031_((float)a1);
            float dz1 = Mth.m_14089_((float)a1);
            float f1 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            float f2 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, dog.m_20185_() + (double)f1 - (double)dx1 * ((double)dog.getDogVisualBbWidth() * 1.8), dog.m_20186_() + (double)offsetY, dog.m_20189_() + (double)f2 - (double)dz1 * ((double)dog.getDogVisualBbWidth() * 1.8), (double)(-dx1) * 0.05, -0.01, (double)(-dz1) * 0.05);
        }

        private void playSizzleSound(AbstractDog dog) {
            RandomSource r = dog.m_217043_();
            if (r.m_188503_(24) == 0) {
                dog.m_9236_().m_7785_(dog.m_20185_(), dog.m_20186_() + (double)dog.m_20206_() + 0.24, dog.m_20189_(), SoundEvents.f_11936_, SoundSource.AMBIENT, 0.6f * r.m_188501_(), r.m_188501_() * 0.7f + 0.3f, false);
            }
        }

        private void populateCooking(AbstractDog dog) {
            if (this.cooking.size() >= 10) {
                return;
            }
            List cookingItems = dog.m_9236_().m_45976_(ItemEntity.class, dog.m_20191_().m_82400_(1.0));
            for (ItemEntity e : cookingItems) {
                ItemStack item;
                SmeltingRecipe recipe;
                if (this.cooking.size() >= 10) break;
                if (this.cooking.containsKey(e) || (recipe = this.getCookedRecipe(dog, item = e.m_32055_())) == null) continue;
                this.cooking.put(e, recipe.m_43753_());
            }
        }

        private void invalidateCooking(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            ArrayList<ItemEntity> removeList = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                if (this.stillValidCooking(dog, entry.getKey())) continue;
                removeList.add(entry.getKey());
            }
            for (ItemEntity e : removeList) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCooking(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.m_9236_().f_46443_ && dog.m_217043_().m_188500_() < 0.1) {
                dog.m_9236_().m_7785_(dog.m_20185_(), dog.m_20186_(), dog.m_20189_(), SoundEvents.f_11907_, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            ArrayList<ItemEntity> finished = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                if (dog.m_9236_().f_46443_) {
                    ItemEntity e = entry.getKey();
                    if (dog.m_217043_().m_188503_(3) != 0) continue;
                    float f1 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * e.m_20205_() * 0.5f;
                    float f2 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * e.m_20205_() * 0.5f;
                    dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, e.m_20185_() + (double)f1, e.m_20186_(), e.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                this.finishCooking(dog, entry.getKey());
                finished.add(entry.getKey());
            }
            for (ItemEntity e : finished) {
                this.cooking.remove(e);
            }
        }

        private void finishCooking(AbstractDog dog, ItemEntity e) {
            ItemStack uncookedItem = e.m_32055_().m_41777_();
            SmeltingRecipe recipe = this.getCookedRecipe(dog, uncookedItem);
            if (recipe == null) {
                return;
            }
            ItemStack cookedItem = recipe.m_8043_(dog.m_9236_().m_9598_()).m_41777_();
            ItemEntity cookedItemEntity = new ItemEntity(dog.m_9236_(), e.m_20185_(), e.m_20186_(), e.m_20189_(), cookedItem);
            cookedItemEntity.m_32060_();
            dog.m_9236_().m_7967_((Entity)cookedItemEntity);
            uncookedItem.m_41774_(1);
            if (uncookedItem.m_41619_()) {
                e.m_146870_();
            } else {
                e.m_32045_(uncookedItem);
            }
        }

        private boolean stillValidCooking(AbstractDog dog, ItemEntity e) {
            double maxDist = (double)(dog.m_20205_() / 2.0f + 1.0f) + 0.5;
            return e.m_6084_() && e.m_20280_((Entity)dog) <= maxDist * maxDist;
        }

        private SmeltingRecipe getCookedRecipe(AbstractDog dog, ItemStack stack) {
            Optional recipeOptional = dog.m_9236_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), dog.m_9236_());
            if (!recipeOptional.isPresent()) {
                return null;
            }
            SmeltingRecipe recipe = (SmeltingRecipe)recipeOptional.get();
            return recipe;
        }
    }
}

