/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DogFoodProjectile
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    private ItemStack foodStack = ItemStack.f_41583_;
    private int tickTillScan = 0;

    public DogFoodProjectile(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DogFoodProjectile(Level worldIn, LivingEntity livingEntityIn) {
        super((EntityType)DoggyEntityTypes.DOG_FOOD_PROJ.get(), livingEntityIn, worldIn);
    }

    public DogFoodProjectile(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)DoggyEntityTypes.DOG_FOOD_PROJ.get(), worldIn);
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.m_9236_().f_46443_ && !this.foodStack.m_41619_()) {
            this.m_19983_(this.foodStack);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.m_19749_() == null) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB aabb = new AABB(pos.m_82520_(-5.0, -5.0, -5.0), pos.m_82520_(5.0, 0.0, 5.0));
        Vec3 moveVec = this.m_20184_();
        Vec3 moveVecXZ = new Vec3(moveVec.f_82479_, 0.0, moveVec.f_82481_).m_82541_();
        if (moveVecXZ.m_82553_() < 1.0) {
            return;
        }
        List dogs = this.m_9236_().m_6443_(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.m_20280_((Entity)this);
        for (Dog dog : dogs) {
            double dist = dog.m_20280_((Entity)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        double dy = this.m_20182_().f_82480_ - nearestDog.m_20182_().f_82480_;
        double minDistXZ = new Vec3(this.m_20182_().f_82479_ - nearestDog.m_20182_().f_82479_, 0.0, this.m_20182_().f_82481_ - nearestDog.m_20182_().f_82481_).m_82556_();
        if (minDist < 4.0) {
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(new DogJumpAndEatAction(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, Vec3 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.m_21827_()) {
            return false;
        }
        if (dog.m_269323_() != this.m_19749_()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.m_20280_((Entity)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return this.dogCanStillEatItem(dog, this.foodStack);
    }

    private boolean checkIfDogCanCatch(Dog dog, Vec3 lookVecXZ) {
        Vec3 dogPosXZ = new Vec3(dog.m_20182_().f_82479_, 0.0, dog.m_20182_().f_82481_);
        Vec3 posXZ = new Vec3(this.m_20182_().f_82479_, 0.0, this.m_20182_().f_82481_);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    private boolean dogCanStillEatItem(Dog dog, ItemStack stack) {
        IDogEddible eddible;
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        if (handler instanceof IDogEddible && (eddible = (IDogEddible)handler).alwaysEatWhenDogConsume(dog)) {
            return true;
        }
        return dog.getDogHunger() < dog.getMaxHunger();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        boolean hasStack = !this.foodStack.m_41619_();
        buffer.writeBoolean(hasStack);
        if (hasStack) {
            buffer.writeItemStack(this.foodStack, true);
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        boolean hasStack = buffer.readBoolean();
        if (hasStack) {
            this.foodStack = buffer.m_130267_();
        }
    }

    public ItemStack getDogFoodStack() {
        return this.foodStack;
    }

    public void setDogFoodStack(ItemStack stack) {
        this.foodStack = stack;
    }

    public boolean feedDog(Dog dog) {
        if (!this.m_6084_()) {
            return false;
        }
        ItemStack stack = this.getDogFoodStack();
        if (stack.m_41619_()) {
            return false;
        }
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        handler.consume(dog, stack, null);
        if (stack.m_41619_()) {
            this.m_146870_();
        }
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
    }

    public static class DogJumpAndEatAction
    extends TriggerableAction {
        private DogFoodProjectile target;
        private int tickTillJump;
        private int tickTillConsumeItem;
        private int stopTick;
        private boolean consumed = false;

        public DogJumpAndEatAction(Dog dog, DogFoodProjectile target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.f_19797_ + DogAnimation.BACKFLIP.getLengthTicks();
            this.dog.setAnim(DogAnimation.BACKFLIP);
            this.tickTillJump = 3;
            this.tickTillConsumeItem = 5;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.f_19797_ >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillJump == 0) {
                this.dog.m_21569_().m_24901_();
            }
            if (!this.consumed && --this.tickTillConsumeItem <= 0) {
                this.tryConsumeItem();
            }
        }

        public void tryConsumeItem() {
            if (!this.target.m_6084_()) {
                return;
            }
            if (this.dog.m_20280_((Entity)this.target) > 4.0) {
                return;
            }
            this.target.feedDog(this.dog);
            this.consumed = true;
        }

        @Override
        public void onStop() {
            this.dog.m_21573_().m_26573_();
            if (this.dog.getAnim() == DogAnimation.BACKFLIP) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }
    }
}

