/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.config;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static ClientConfig CLIENT;
    public static ServerConfig SERVER;
    public static TalentConfig TALENT;
    public static RespawnTagConfig RESPAWN_TAGS;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;
    private static ForgeConfigSpec CONFIG_CLIENT_SPEC;
    private static ForgeConfigSpec CONFIG_TALENT_SPEC;
    private static ForgeConfigSpec CONFIG_RESPAWN_TAG_SPEC;
    public static final boolean ALWAYS_SHOW_DOG_NAME = true;
    public static final float DEFAULT_MAX_HUNGER = 120.0f;
    public static final boolean SEND_SKIN = false;
    public static final boolean DISPLAY_OTHER_DOG_SKINS = false;
    public static final boolean WHISTLE_SOUNDS = true;

    public static void init(IEventBus modEventBus) {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG_CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_CLIENT_SPEC);
        ConfigHandler.initRespawnTagsConfig();
    }

    public static void initTalentConfig() {
        Pair talentPair = new ForgeConfigSpec.Builder().configure(TalentConfig::new);
        CONFIG_TALENT_SPEC = (ForgeConfigSpec)talentPair.getRight();
        TALENT = (TalentConfig)talentPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_TALENT_SPEC, "doggytalents-talents.toml");
    }

    public static void initRespawnTagsConfig() {
        Pair respawnPair = new ForgeConfigSpec.Builder().configure(RespawnTagConfig::new);
        CONFIG_RESPAWN_TAG_SPEC = (ForgeConfigSpec)respawnPair.getRight();
        RESPAWN_TAGS = (RespawnTagConfig)respawnPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_RESPAWN_TAG_SPEC, "doggytalents-respawn_tags_to_remove.toml");
    }

    public static class ServerConfig {
        public ForgeConfigSpec.BooleanValue DISABLE_HUNGER;
        public ForgeConfigSpec.BooleanValue STARTING_ITEMS;
        public ForgeConfigSpec.BooleanValue DISABLE_GENDER;
        public ForgeConfigSpec.BooleanValue PUPS_GET_PARENT_LEVELS;
        public ForgeConfigSpec.BooleanValue IMMORTAL_DOGS;
        public ForgeConfigSpec.BooleanValue PLAY_TAG_WITH_DOG;
        public ForgeConfigSpec.BooleanValue DOG_GREET_OWNER;
        public ForgeConfigSpec.IntValue DOG_GREET_OWNER_LIMIT;
        public ForgeConfigSpec.BooleanValue MAX_CREEPER_SWEEPER_DONT_GROWL;
        public ForgeConfigSpec.BooleanValue ALL_PLAYER_CANNOT_ATTACK_DOG;
        public ForgeConfigSpec.BooleanValue ALL_DOG_BLOCK_PORTAL;
        public ForgeConfigSpec.IntValue MAX_HEEL_LIMIT;
        public ForgeConfigSpec.BooleanValue PREVENT_DOGS_PUSHING_EACH_OTHER;
        public ForgeConfigSpec.IntValue TICK_PER_HUNGER_DEC;
        public ForgeConfigSpec.BooleanValue DISABLE_PRESERVE_UUID;
        public ForgeConfigSpec.IntValue DUPLICATION_RESOLVE_STRATEGY;
        public ForgeConfigSpec.BooleanValue DISABLE_TRAIN_UNTAMED_WOLF;
        public ForgeConfigSpec.BooleanValue DOG_RESPAWN_INCAPACITATED_WHEN_KILLED;
        public ForgeConfigSpec.BooleanValue MOB_RETRIEVER_ONLY_CARRY_DOG;
        public ForgeConfigSpec.BooleanValue WOLF_MOUNT_PASSENGER_COLLISION;
        public ForgeConfigSpec.BooleanValue CONDUCTING_BONE_CROSS_ORIGIN;
        public ForgeConfigSpec.BooleanValue INCAP_VAL_RESET_WHEN_HURT;
        public Map<String, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Constants");
            this.DISABLE_HUNGER = builder.comment("By default, Dogs can starve to Incapacitated if are not fed properly.").comment("Disable this to prevent this behaviour. Do note that you can still feed").comment("your Dog to recover health.").translation("doggytalents.config.dog.disable_hunger").define("disable_hunger", false);
            this.STARTING_ITEMS = builder.comment("When enabled, DTN will provide new players of this world").comment("(relative to the point that this option is first enabled on this world)").comment("a Starter Bundle which contains certain key items which assist you in starting").comment("with DTN.").translation("doggytalents.config.enable_starter_bundle").define("enable_starter_bundle", false);
            this.DISABLE_GENDER = builder.comment("By default, each Dog will be one of the Biological Genders. This, like how Biological Genders").comment("work, add restrictions how Dogs can breed. Therefore, only Dogs whose gender is Biologically Opposed").comment("can mate with each other. Set this to true to disable this behaviour.").translation("doggytalents.config.disable_dog_gender").define("disable_dog_gender", false);
            this.PUPS_GET_PARENT_LEVELS = builder.comment("When enabled, puppies get some levels from their parents. When disabled, puppies start at 0 points.").translation("doggytalents.config.enable_pup_get_parent_levels").define("enable_pup_get_parent_levels", false);
            this.IMMORTAL_DOGS = builder.comment("When enabled, dogs cannot be killed by any means (except creative-mode-bypass damage, in that case, you can still respawn your dog using his linked bed or commands).").comment("Instead, when his health reaches Zero, he will go into Incapacitated Mode.").translation("doggytalents.config.immortal_dogs").define("immortal_dogs", true);
            this.PLAY_TAG_WITH_DOG = builder.comment("When enabled, dog can play tag with you. To make them play, throw a snowball at them.").translation("doggytalents.config.play_tag_with_dog").define("play_tag_with_dog", true);
            this.DOG_GREET_OWNER = builder.comment("When enabled, dogs will start to miss you when you leave them for too long.").comment("And when you come back, they will rush to you and greet you with love!").translation("doggytalents.dog_greet_owner").define("dog_greet_owner", true);
            this.DOG_GREET_OWNER_LIMIT = builder.comment("Specify how many dogs can greet you when you approach more than one missing dog.").comment("The remaning dogs will remain in their position.").comment("To disable the limit, set this to any non-positive integer.").comment("Although this will cause all of your dogs to stand up and greet.").comment("YOU HAVE BEEN WARNED! :)").translation("doggytalents.dog_greet_owner_limit").defineInRange("dog_greet_owner_limit", 5, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.MAX_CREEPER_SWEEPER_DONT_GROWL = builder.comment("Option to disable dogs who mastered Creeper Sweeper and ").comment("and are able to tackle Creepers. This is helpful if players intend").comment("their Creeper Sweeper master dogs to focus on fighting Creeper instead of").comment("warning you, which may causes a bunch of false positives due to the range").comment("being so wide that it includes Creepers which are not in danger zone or not reachable.").translation("doggytalents.max_creeper_sweeper_dont_growl").define("max_creeper_sweeper_dont_growl", true);
            this.ALL_PLAYER_CANNOT_ATTACK_DOG = builder.comment("Option to disable friendly fire for all players toward all dogs.").comment("This is used to always be the case with friendly fire disabled for a single dog.").translation("doggytalents.all_player_cannot_attack_dog").define("all_player_cannot_attack_dog", false);
            this.ALL_DOG_BLOCK_PORTAL = builder.comment("Option to prevent dogs from accidentally going into a portal and get").comment("unnecessary transferred to another dimension, causing the owner to have").comment("to take them back. The preferred way to make a dog go to another dimension is").comment("to have Cross Origin Teleport set to true on that dog.").translation("doggytalents.all_dog_block_portal").define("all_dog_block_portal", true);
            this.MAX_HEEL_LIMIT = builder.comment("Define how many dogs a player can listen to commands which summon more than one dog to you").comment("at the same time. Set this to any negative value to remove the limit completely.").translation("doggytalents.max_heel_limit").defineInRange("max_heel_limit", 20, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.PREVENT_DOGS_PUSHING_EACH_OTHER = builder.comment("Prevent dogs from pushing each other when navigating, this prevents dogs from pushing").comment("another dog into a dangerous area and improves navigation.").translation("doggytalents.prevent_dogs_pushing_each_other").define("prevent_dogs_pushing_each_other", true);
            this.TICK_PER_HUNGER_DEC = builder.comment("Configure how many ticks it usually take for the dog to drop one hunger unit.").translation("doggytalents.tick_per_hunger_dec").defineInRange("tick_per_hunger_dec", 400, 10, Integer.MAX_VALUE);
            this.DISABLE_PRESERVE_UUID = builder.comment("Determine if the UUIDs of the dogs are being kept when training from vanilla").comment("and when they respawn on bed. This also allows Duplication Detection.").translation("doggytalents.preserve_uuid").define("preserve_uuid", false);
            this.DUPLICATION_RESOLVE_STRATEGY = builder.comment("Duplication Detection").comment("Specify what to do when a Duplication is detected when third parties are trying").comment("to load the dog from their own copy.").comment("Option are specified via the following Integer values").comment("0 - Throw an exception out, this may produce a crash. However, this is the recommended way.").comment("1 - Silently remove the dog.").comment("Other - Do nothing.").translation("doggytalents.duplication_resolve_strategy").defineInRange("duplication_resolve_strategy", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.DISABLE_TRAIN_UNTAMED_WOLF = builder.comment("By default, you can directly train an untamed wolf to a Dog").comment("with a Training Treat. Set this to True to disable.").translation("doggytalents.train_untamed_wolf").define("train_untamed_wolf", false);
            this.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED = builder.comment("By default, Dogs respawning from bed after being killed will").comment("be incapacitated and are required to be nursed back to life.").comment("Set this to False to disable.").translation("doggytalents.dog_respawn_incapacitated_when_killed").define("dog_respawn_incapacitated_when_killed", true);
            this.MOB_RETRIEVER_ONLY_CARRY_DOG = builder.comment("Enable this if you prefer Mob Retriever to only work with DTN's dog.").translation("doggytalents.mob_retriever_only_carry_dog").define("mob_retriever_only_carry_dog", false);
            this.WOLF_MOUNT_PASSENGER_COLLISION = builder.comment("By default, Dogs extend their bounding box covering the passengers").comment("to avoid suffocating them while calculating the appropriate path.").comment("Set this to false to disable it, but be warned, although Mob Retriever Dogs will still").comment("try to calculate the appropriate path while carrying another mob, there might be accidental suffocations.").translation("doggytalents.wolf_mount_passenger_collision").define("wolf_mount_passenger_collision", true);
            this.CONDUCTING_BONE_CROSS_ORIGIN = builder.comment("By default, Conducting Bone users can summon their Dogs even when they are in").comment("other dimensions. Set this to false to limit Conducting Bone Users to only summon").comment("Dogs of the same dimension.").translation("doggytalents.conducting_bone_cross_origin").define("conducting_bone_cross_origin", true);
            this.INCAP_VAL_RESET_WHEN_HURT = builder.comment("Determine if Dog's incapacitated value should be reset when taking any damage").comment("while being Incapacitated.").translation("doggytalents.incap_val_reset_when_hurt").define("incap_val_reset_when_hurt", true);
            builder.pop();
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_SERVER_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class ClientConfig {
        public ForgeConfigSpec.BooleanValue KAMI_PARTICLES;
        public ForgeConfigSpec.BooleanValue RENDER_CHEST;
        public ForgeConfigSpec.BooleanValue USE_DT_TEXTURES;
        public ForgeConfigSpec.BooleanValue RENDER_INCAPACITATED_TEXTURE;
        public ForgeConfigSpec.BooleanValue RENDER_HEALTH_IN_NAME;
        public ForgeConfigSpec.BooleanValue DOG_INV_BUTTON_IN_INV;
        public ForgeConfigSpec.BooleanValue RENDER_INCAP_TXT_LESS_GRAPHIC;
        public ForgeConfigSpec.BooleanValue RENDER_DIFFOWNER_NAME_DIFFERENT;
        public ForgeConfigSpec.BooleanValue DONT_RENDER_DIFFOWNER_NAME;
        public ForgeConfigSpec.BooleanValue ALWAYS_RENDER_DOG_NAME;
        public ForgeConfigSpec.BooleanValue BLOCK_THIRD_PARTY_NAMETAG;
        public ForgeConfigSpec.BooleanValue USE_VANILLA_RES_FOR_CLASSICAL;
        public ForgeConfigSpec.BooleanValue WORD_LOAD_ICON;
        public ForgeConfigSpec.BooleanValue RENDER_ARMOR;
        public ForgeConfigSpec.BooleanValue BLOCK_RED_OVERLAY_WHEN_HURT;
        public ForgeConfigSpec.BooleanValue DISPLAY_SMOKE_WHEN_ON_FIRE;
        public ForgeConfigSpec.BooleanValue MOUTH_ITEM_FORCE_RENDER;
        public ForgeConfigSpec.IntValue MAX_ANIMATION_LATENCY_ALLOWED;
        public ForgeConfigSpec.BooleanValue USE_LEGACY_DOG_ARMOR_RENDER;
        public ForgeConfigSpec.BooleanValue USE_PLAYER_HELMET_MODEL_BY_DEFAULT;
        public ForgeConfigSpec.BooleanValue USE_THIRD_PARTY_PLAYER_HELMET_MODEL;
        public ForgeConfigSpec.BooleanValue ENABLE_STARTER_BUNDLE_BY_DEFAULT;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Render");
            this.KAMI_PARTICLES = builder.comment("Enables the particle effect on Full Kami dogs.").translation("doggytalents.config.client.enable_kami_particles").define("enable_kami_particles", false);
            this.RENDER_CHEST = builder.comment("Disable this if you want to force all PackPuppy Dog to not render their Chest.").translation("doggytalents.config.client.render_chest").define("render_chest", true);
            this.USE_DT_TEXTURES = builder.comment("Disable this if you prefer to have The Classical Skin rendered on all dog regardless.").translation("doggytalents.config.client.always_render_classical_skin").define("always_render_classical_skin", true);
            this.RENDER_INCAPACITATED_TEXTURE = builder.comment("When enabled, Dogs will show injured texture while incapacitated.").translation("doggytalents.config.client.render_incapacitated_overlay").define("render_incapacitated_overlay", true);
            this.RENDER_HEALTH_IN_NAME = builder.comment("When sneaking, a part of the dog's name will be rendered with a certain color").comment(", the length of the part is based on the health percentage the dog has left").translation("doggytalents.config.client.render_health_in_name").define("render_health_in_name", true);
            this.DOG_INV_BUTTON_IN_INV = builder.comment("Render a universal dog inventory access button in your inventory gui.").comment("If this is turned off, you can still access the button via the dog's").comment("GUI in Talents > Pack Puppy.").translation("doggytalents.config.client.dog_inv_button_in_inv").define("dog_inv_button_in_inv", true);
            this.RENDER_INCAP_TXT_LESS_GRAPHIC = builder.comment("If the default incapacitated texture proof too many graphics.").comment("You can substitute this friendlier texture instead.").translation("doggytalents.config.client.render_incap_txt_less_graphic").define("render_incap_txt_less_graphic", false);
            this.RENDER_DIFFOWNER_NAME_DIFFERENT = builder.comment("Render the dogs' name whose owner is not you with a different color.").translation("doggytalents.config.client.render_diffowner_name_different").define("render_diffowner_name_different", true);
            this.DONT_RENDER_DIFFOWNER_NAME = builder.comment("Do not render dogs' names whose owner is not you.").translation("doggytalents.config.client.render_diffowner_name_dont").define("render_diffowner_name_dont", false);
            this.ALWAYS_RENDER_DOG_NAME = builder.comment("Always render dog nametags regardless even if the player blocks it by F1 mode.").translation("doggytalents.config.client.always_render_dog_name").define("always_render_dog_name", false);
            this.BLOCK_THIRD_PARTY_NAMETAG = builder.comment("Attempt to block third parties from rendering overlays that may conflict").comment("with DT's built-in tag. It is recommended that this be achieved via the target third-party's").comment("configurations if they have the option to disable nametag overlay for certain mobs").comment("(Which they should). This option should only be used as the last resort.").translation("doggytalents.config.client.block_third_party_nametag").define("block_third_party_nametag", false);
            this.USE_VANILLA_RES_FOR_CLASSICAL = builder.comment("By default, a copy of the Classical (Vanilla Wolf Texture) provided by the mod").comment("is used to render The Classical Skin, this is to avoid conflicts with resource packs").comment("like Fresh Animations which are directly using the in-game wolf texture. Turning this on").comment("will make DTN directly reference the in-game texture.").translation("doggytalents.config.client.use_vanilla_res_for_classical").define("use_vanilla_res_for_classical", false);
            this.WORD_LOAD_ICON = builder.comment("Show a fun icon on world loading screen.").translation("doggytalents.config.client.world_load_icon").define("world_load_icon", true);
            this.RENDER_ARMOR = builder.comment("Determine if dogs will render their armor.").translation("doggytalents.config.client.render_armor").define("render_armor", true);
            this.BLOCK_RED_OVERLAY_WHEN_HURT = builder.comment("Determine if dogs still render with a red overlay upon hurt like they usually do.").comment("This can be toggled on if the user prefers to not have the red overlay and relies on the animation ").comment("to indicate hurting.").translation("doggytalents.config.client.block_red_overlay_when_hurt").define("block_red_overlay_when_hurt", false);
            this.DISPLAY_SMOKE_WHEN_ON_FIRE = builder.comment("Display extra smoke when the dog is on fire.").translation("doggytalents.config.client.display_smoke_when_on_fire").define("display_smoke_when_on_fire", true);
            this.MOUTH_ITEM_FORCE_RENDER = builder.comment("By default, dogs will render items in their mouth, regardless of models.").comment("This can be disabled if you prefer not to render it on some").comment("less compatible model.").translation("doggytalents.config.client.mouth_item_force_render").define("mouth_item_force_render", true);
            this.MAX_ANIMATION_LATENCY_ALLOWED = builder.comment("Specify the max latency allowed before force adjusting the animation time").comment("client side to sync with server's animation time. The unit is in ticks.").comment("Provide a non positive integer to disable this. Value from 0 to 7 both inclusive will be defaulted to 7.").translation("doggytalents.config.client.max_animation_latency_allowed").defineInRange("max_animation_latency_allowed", 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.USE_LEGACY_DOG_ARMOR_RENDER = builder.comment("Currently, DTN is utilizing a new system for rendering Doggy Armor's Armor").comment("which allows DTN to directly use any texture which the armor item provided").comment("for the player, thus better replicating third-party armor. Set this to true").comment("if you prefer to use the old system instead.").translation("doggytalents.config.client.use_legacy_dog_armor_render").define("use_legacy_dog_armor_render", false);
            this.USE_THIRD_PARTY_PLAYER_HELMET_MODEL = builder.comment("By default, DTN will try querying models from third parties designed for the player when").comment("rendering helmet on the Dog. Disable this to force DTN to use either vanilla's player model or").comment("DTN provided model designed for Dogs (specified by the below option).").translation("doggytalents.config.client.use_third_party_player_helmet_model").define("use_third_party_player_helmet_model", false);
            this.USE_PLAYER_HELMET_MODEL_BY_DEFAULT = builder.comment("By default, if there is no custom Helmet Armor model for the Helmet Item,").comment("DTN will use its own helmet armor model designed for DTN Dog to").comment("render it on the Dog's head. Enable this to make DTN reuse the player's Helmet Model instead.").translation("doggytalents.config.client.use_player_helmet_model_by_default").define("use_player_helmet_model_by_default", false);
            this.ENABLE_STARTER_BUNDLE_BY_DEFAULT = builder.comment("Enable this to allow every World which is running on this Minecraft").comment("instance's Integrated Server to provide new players with a Starter Bundle").comment("regardless of the world's serverconfig.").translation("doggytalents.config.client.enable_starter_bundle_by_default").define("enable_starter_bundle_by_default", false);
            builder.pop();
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_CLIENT_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class TalentConfig {
        public Map<Talent, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public TalentConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Here you can disable talents.").comment("Notice that players with admin privileges can bypass this.").push("Talents");
            this.DISABLED_TALENTS = new HashMap<Talent, ForgeConfigSpec.BooleanValue>();
            DoggyTalentsAPI.TALENTS.get().forEach(loc -> this.DISABLED_TALENTS.put((Talent)loc, builder.define(DoggyTalentsAPI.TALENTS.get().getKey(loc).toString(), true)));
            builder.pop();
        }

        public boolean getFlag(Talent talent) {
            ForgeConfigSpec.BooleanValue booleanValue = this.DISABLED_TALENTS.get(talent);
            if (booleanValue == null) {
                return true;
            }
            return (Boolean)TalentConfig.getConfig(booleanValue);
        }

        public static <T> T getConfig(ForgeConfigSpec.ConfigValue<T> config) {
            if (CONFIG_TALENT_SPEC.isLoaded()) {
                return (T)config.get();
            }
            return (T)config.getDefault();
        }
    }

    public static class RespawnTagConfig {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> TAGS_TO_REMOVE;

        public RespawnTagConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Extra tags to be removed when a dog is respawned.");
            this.TAGS_TO_REMOVE = builder.translation("doggytalents.respawn_removal_tags").defineList("respawn_removal_tags", List.of(), obj -> obj instanceof String);
        }
    }
}

