/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import doggytalents.common.command.arguments.UUIDArgument;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggyCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARG_TYPE = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.COMMAND_ARGUMENT_TYPES, (String)"doggytalents");
    public static final RegistryObject<SingletonArgumentInfo<UUIDArgument>> SUUID = ARG_TYPE.register("doggy_uuid", () -> SingletonArgumentInfo.m_235451_(UUIDArgument::uuid));
    public static final DynamicCommandExceptionType NOTFOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> Component.m_237110_((String)"command.dogrespawn.notfound", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType RESPAWN_EXCEPTION = new DynamicCommandExceptionType(arg -> Component.m_237110_((String)"command.dogrespawn.exception", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType AMBIGUOUS_NAME_EXCEPTION = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"command.dogrespawn.imprecise", (Object[])new Object[]{name}));
    public static final DynamicCommandExceptionType BAD_UUID_STRING = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"command.dogrespawn.bad_uuid_str", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dog").requires(s -> s.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").then(Commands.m_82127_((String)"byuuid").then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsLocate()).then(Commands.m_82129_((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsLocate()).executes(c -> DoggyCommands.locate((CommandContext<CommandSourceStack>)c)))))).then(Commands.m_82127_((String)"byname").then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsLocate()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dogName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogNameSuggestionsLocate()).executes(c -> DoggyCommands.locate2((CommandContext<CommandSourceStack>)c))).then(Commands.m_82129_((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsLocate()).executes(c -> DoggyCommands.locate((CommandContext<CommandSourceStack>)c)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revive").then(Commands.m_82127_((String)"byuuid").then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsRevive()).then(Commands.m_82129_((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsRevive()).executes(c -> DoggyCommands.respawn((CommandContext<CommandSourceStack>)c)))))).then(Commands.m_82127_((String)"byname").then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsRevive()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dogName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogNameSuggestionsRevive()).executes(c -> DoggyCommands.respawn2((CommandContext<CommandSourceStack>)c))).then(Commands.m_82129_((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsRevive()).executes(c -> DoggyCommands.respawn((CommandContext<CommandSourceStack>)c))))))));
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getOwnerIdSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getOwnerIdSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getOwnerIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().map(IDogData::getOwnerId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getDogIdSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getDogIdSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getDogIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            String dogName = null;
            String ownerName = (String)context.getArgument("ownerName", String.class);
            try {
                dogName = (String)context.getArgument("dogName", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (ownerName == null) {
                return Suggestions.empty();
            }
            String dogName2 = dogName;
            Predicate<IDogData> filter = dogName2 == null ? data -> ownerName.equals(data.getOwnerName()) : data -> dogName2.equals(data.getDogName()) && ownerName.equals(data.getOwnerName());
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().filter(filter).map(IDogData::getDogId).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getOwnerNameSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getOwnerNameSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    public static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getOwnerNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().map(IDogData::getOwnerName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getDogNameSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getDogNameSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    public static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getDogNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            String ownerName = (String)context.getArgument("ownerName", String.class);
            if (ownerName == null) {
                return Suggestions.empty();
            }
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().filter(data -> ownerName.equals(data.getOwnerName())).map(IDogData::getDogName).filter(str -> !Strings.isNullOrEmpty((String)str)).map(str -> DoggyCommands.wrapStringInQuoteIfContainsSpace(str)).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static String wrapStringInQuoteIfContainsSpace(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int spaceIndx = str.indexOf(" ");
        if (spaceIndx < 0) {
            return str;
        }
        return "\"" + str + "\"";
    }

    private static int respawn(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String uuidStr = (String)ctx.getArgument("dogUUID", String.class);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            throw BAD_UUID_STRING.create((Object)"null");
        }
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((Level)world);
        DogRespawnData respawnData = respawnStorage.getData(uuid);
        if (respawnData == null) {
            throw NOTFOUND_EXCEPTION.create((Object)uuid.toString());
        }
        return DoggyCommands.respawn(respawnStorage, respawnData, source);
    }

    private static int respawn2(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String ownerName = (String)ctx.getArgument("ownerName", String.class);
        String dogName = (String)ctx.getArgument("dogName", String.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((Level)world);
        List respawnData = respawnStorage.getDogs(ownerName).filter(data -> data.getDogName().equals(dogName)).collect(Collectors.toList());
        if (respawnData.isEmpty()) {
            throw NOTFOUND_EXCEPTION.create((Object)dogName);
        }
        if (respawnData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogRespawnData data2 : respawnData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw AMBIGUOUS_NAME_EXCEPTION.create((Object)dogName);
        }
        return DoggyCommands.respawn(respawnStorage, (DogRespawnData)respawnData.get(0), source);
    }

    private static int respawn(DogRespawnStorage respawnStorage, DogRespawnData respawnData, CommandSourceStack source) throws CommandSyntaxException {
        Dog dog = respawnData.respawn(source.m_81372_(), (Player)source.m_81375_(), source.m_81375_().m_20183_().m_7494_());
        if (dog != null) {
            respawnStorage.remove(respawnData.getDogId());
            source.m_288197_(() -> Component.m_237110_((String)"commands.dogrespawn.uuid.success", (Object[])new Object[]{respawnData.getDogName()}), false);
            return 1;
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.dogrespawn.uuid.failure", (Object[])new Object[]{respawnData.getDogName()}), false);
        return 0;
    }

    private static int locate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String uuidStr = (String)ctx.getArgument("dogUUID", String.class);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            throw BAD_UUID_STRING.create((Object)"null");
        }
        DogLocationStorage locationStorage = DogLocationStorage.get((Level)world);
        DogLocationData locationData = locationStorage.getData(uuid);
        if (locationData == null) {
            throw NOTFOUND_EXCEPTION.create((Object)uuid.toString());
        }
        return DoggyCommands.locate(locationStorage, locationData, source);
    }

    private static int locate2(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String ownerName = (String)ctx.getArgument("ownerName", String.class);
        String dogName = (String)ctx.getArgument("dogName", String.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((Level)world);
        List locationData = locationStorage.getAll().stream().filter(data -> ownerName.equals(data.getOwnerName())).filter(data -> data.getDogName().equals(dogName)).collect(Collectors.toList());
        if (locationData.isEmpty()) {
            throw NOTFOUND_EXCEPTION.create((Object)dogName);
        }
        if (locationData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogLocationData data2 : locationData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw AMBIGUOUS_NAME_EXCEPTION.create((Object)dogName);
        }
        return DoggyCommands.locate(locationStorage, (DogLocationData)locationData.get(0), source);
    }

    private static int locate(DogLocationStorage respawnStorage, DogLocationData locationData, CommandSourceStack source) throws CommandSyntaxException {
        source.m_288197_(() -> DoggyCommands.getLocationInfo(locationData), false);
        return 1;
    }

    public static Component getLocationInfo(DogLocationData loc) {
        ResourceLocation dim_loc;
        Vec3 pos = loc.getPos();
        BlockPos bpos = null;
        if (pos != null) {
            bpos = BlockPos.m_274446_((Position)pos);
        }
        String posStr = bpos == null ? "[???]" : "[ " + bpos.m_123341_() + ", " + bpos.m_123342_() + ", " + bpos.m_123343_() + " ]";
        ResourceKey<Level> dim = loc.getDimension();
        ResourceLocation resourceLocation = dim_loc = dim == null ? null : dim.m_135782_();
        String dimStr = dim == null ? "[???]" : "[ " + (Comparable)((Object)(dim_loc == null ? "" : dim_loc)) + " ]";
        String dogName = loc.getDogName();
        if (dogName == null) {
            dogName = "noname";
        }
        return Component.m_237110_((String)"command.doglocate.info", (Object[])new Object[]{dogName, posStr, dimStr});
    }
}

