/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.google.common.collect.Maps;
import doggytalents.api.impl.BeddingMaterial;
import doggytalents.api.impl.CasingMaterial;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class DogBedMaterialManager {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final ResourceLocation NANI_KEY = Util.getResource("textures/block/dog_bed_nani");
    public static final ResourceLocation NANI_TEXTURE = Util.getResource("block/dog_bed_casing_nani");
    private static final Map<ResourceLocation, IBeddingMaterial> beddingMap = Maps.newConcurrentMap();
    private static final Map<ResourceLocation, ICasingMaterial> casingMap = Maps.newConcurrentMap();
    private static final Map<IBeddingMaterial, ResourceLocation> beddingKeyMap = Maps.newConcurrentMap();
    private static final Map<ICasingMaterial, ResourceLocation> casingKeyMap = Maps.newConcurrentMap();

    public static Map<ResourceLocation, IBeddingMaterial> getBeddings() {
        return beddingMap;
    }

    public static Map<ResourceLocation, ICasingMaterial> getCasings() {
        return casingMap;
    }

    public static IBeddingMaterial getBedding(ResourceLocation loc) {
        IBeddingMaterial ret = beddingMap.get(loc);
        if (ret == null) {
            return new NaniBedding(loc);
        }
        return ret;
    }

    public static ICasingMaterial getCasing(ResourceLocation loc) {
        ICasingMaterial ret = casingMap.get(loc);
        if (ret == null) {
            return new NaniCasing(loc);
        }
        return ret;
    }

    public static IBeddingMaterial getBedding(CompoundTag tag, String id) {
        ResourceLocation loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getBedding(loc);
    }

    public static ICasingMaterial getCasing(CompoundTag tag, String id) {
        ResourceLocation loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getCasing(loc);
    }

    public static ResourceLocation getKey(IBeddingMaterial loc) {
        if (loc == null) {
            return NANI_KEY;
        }
        if (loc instanceof NaniBedding) {
            NaniBedding nani = (NaniBedding)loc;
            return nani.missingLoc().isPresent() ? nani.missingLoc().get() : NANI_KEY;
        }
        ResourceLocation ret = beddingKeyMap.get(loc);
        if (ret == null) {
            return NANI_KEY;
        }
        return ret;
    }

    public static ResourceLocation getKey(ICasingMaterial loc) {
        if (loc == null) {
            return NANI_KEY;
        }
        if (loc instanceof NaniCasing) {
            NaniCasing nani = (NaniCasing)loc;
            return nani.missingLoc().isPresent() ? nani.missingLoc().get() : NANI_KEY;
        }
        ResourceLocation ret = casingKeyMap.get(loc);
        if (ret == null) {
            return NANI_KEY;
        }
        return ret;
    }

    public static IBeddingMaterial randomBedding() {
        List list = beddingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniBedding)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniBedding.NULL;
        }
        return (IBeddingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static ICasingMaterial randomCasing() {
        List list = casingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniCasing)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniCasing.NULL;
        }
        return (ICasingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static void refresh(TagsUpdatedEvent.UpdateCause cause) {
        beddingMap.clear();
        casingMap.clear();
        DogBedMaterialManager.populateBedding(cause);
        DogBedMaterialManager.populateCasing(cause);
    }

    private static void populateBedding(TagsUpdatedEvent.UpdateCause cause) {
        List<Block> blocks = DogBedMaterialManager.fetchBeddingBlocks();
        for (Block block : blocks) {
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
            IBeddingMaterial value = new BeddingMaterial(() -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(((IBeddingMaterial)value).getTexture())) {
                value = new NaniBedding(id);
            }
            beddingMap.put(id, value);
            beddingKeyMap.put(value, id);
        }
    }

    private static void populateCasing(TagsUpdatedEvent.UpdateCause cause) {
        List<Block> blocks = DogBedMaterialManager.fetchCasingBlocks();
        for (Block block : blocks) {
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
            ICasingMaterial value = new CasingMaterial(() -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(((ICasingMaterial)value).getTexture())) {
                value = new NaniCasing(id);
            }
            casingMap.put(id, value);
            casingKeyMap.put(value, id);
        }
    }

    private static List<Block> fetchCasingBlocks() {
        ITagManager tags = ForgeRegistries.BLOCKS.tags();
        List planks = tags.getTag(BlockTags.f_13090_).stream().collect(Collectors.toList());
        List logs = tags.getTag(BlockTags.f_13106_).stream().collect(Collectors.toList());
        ArrayList<Block> ret = new ArrayList<Block>(planks.size() + logs.size());
        ret.addAll(planks);
        ret.addAll(logs);
        return ret;
    }

    private static List<Block> fetchBeddingBlocks() {
        ITagManager tags = ForgeRegistries.BLOCKS.tags();
        List wools = tags.getTag(BlockTags.f_13089_).stream().collect(Collectors.toList());
        ArrayList<Block> ret = new ArrayList<Block>(wools.size());
        ret.addAll(wools);
        return ret;
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.refresh(event.getUpdateCause());
    }

    public static class NaniBedding
    extends IBeddingMaterial {
        public static final NaniBedding NULL = new NaniBedding(null);
        private Optional<ResourceLocation> missingLoc;

        public NaniBedding(ResourceLocation loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public ResourceLocation getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public Component getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return Component.m_237115_((String)retStr).m_130940_(ChatFormatting.RED);
        }

        @Override
        public Ingredient getIngredient() {
            return Ingredient.f_43901_;
        }

        public Optional<ResourceLocation> missingLoc() {
            return this.missingLoc;
        }
    }

    public static class NaniCasing
    extends ICasingMaterial {
        public static final NaniCasing NULL = new NaniCasing(null);
        private Optional<ResourceLocation> missingLoc;

        public NaniCasing(ResourceLocation loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public ResourceLocation getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public Component getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return Component.m_237115_((String)retStr).m_130940_(ChatFormatting.RED);
        }

        @Override
        public Ingredient getIngredient() {
            return Ingredient.f_43901_;
        }

        public Optional<ResourceLocation> missingLoc() {
            return this.missingLoc;
        }
    }
}

