/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.artifacts;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.item.DoggyArtifactItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeMod;

public class FeatheredMantleArtifact
extends DoggyArtifact {
    private static final UUID PILLOW_PAW_BOOST_ID = UUID.fromString("1f002df0-9d35-49c6-a863-b8945caa4af4");
    private boolean glide = false;

    public FeatheredMantleArtifact() {
        super(() -> (DoggyArtifactItem)((Object)((Object)DoggyItems.FEATHERED_MANTLE.get())));
    }

    @Override
    public void init(AbstractDog dogIn) {
        if (dogIn.getDogLevel((Supplier)DoggyTalents.PILLOW_PAW) < 5) {
            return;
        }
        this.startGliding(dogIn);
        this.glide = true;
    }

    @Override
    public void remove(AbstractDog dogIn) {
        if (!this.glide) {
            return;
        }
        this.stopGliding(dogIn);
        this.glide = false;
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (dogIn.getDogLevel((Supplier)DoggyTalents.PILLOW_PAW) < 5) {
            return;
        }
        dogIn.f_19789_ = 0.0f;
    }

    private void startGliding(AbstractDog dog) {
        dog.setAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), PILLOW_PAW_BOOST_ID, this::createSpeedModifier);
    }

    private void stopGliding(AbstractDog dog) {
        dog.removeAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), PILLOW_PAW_BOOST_ID);
    }

    public AttributeModifier createSpeedModifier(AbstractDog dogIn, UUID uuidIn) {
        return new AttributeModifier(uuidIn, "Pillow Paw", -0.8, AttributeModifier.Operation.MULTIPLY_BASE);
    }
}

