/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollBar
extends AbstractWidget {
    private int barSize;
    private double barOffset;
    private Direction dir;
    private Screen screen;
    private boolean holdInflate;
    private long inflateAnim = 0L;
    private final long MAX_INFLATE_ANIM = 50L;
    private long prevAnimUpdateMillis = 0L;
    private boolean startedAnimate = false;

    public ScrollBar(int x, int y, int w, int h, Direction dir, int barsize, Screen screen) {
        super(x, y, w, h, (Component)Component.m_237119_());
        this.barSize = dir == Direction.VERTICAL ? Math.min(h, barsize) : Math.min(w, barsize);
        this.dir = dir;
        this.screen = screen;
        this.prevAnimUpdateMillis = System.currentTimeMillis();
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        long currentTimeMillis;
        long passedAnimMillis;
        if (!this.startedAnimate) {
            this.startedAnimate = true;
            this.prevAnimUpdateMillis = System.currentTimeMillis();
        }
        if ((passedAnimMillis = (currentTimeMillis = System.currentTimeMillis()) - this.prevAnimUpdateMillis) > 0L) {
            this.prevAnimUpdateMillis = currentTimeMillis;
        }
        int barOffset = Mth.m_14107_((double)this.barOffset);
        if (this.holdInflate) {
            this.holdInflate = this.screen.m_7282_();
        }
        int BASE_THICK = 3;
        if (passedAnimMillis > 0L) {
            this.inflateAnim = !this.f_93622_ && !this.holdInflate ? (this.inflateAnim -= passedAnimMillis) : (this.inflateAnim += passedAnimMillis);
        }
        if (this.inflateAnim < 0L) {
            this.inflateAnim = 0L;
        }
        if (this.inflateAnim > 50L) {
            this.inflateAnim = 50L;
        }
        float inflateAnimProgress = (float)this.inflateAnim / 50.0f;
        int maxBarThick = this.dir == Direction.VERTICAL ? this.m_5711_() : this.m_93694_();
        int barThickAfterAnim = 3 + Mth.m_14167_((float)(inflateAnimProgress * (float)maxBarThick));
        if (this.dir == Direction.VERTICAL) {
            graphics.m_280509_(this.m_252754_() + this.f_93618_ - barThickAfterAnim, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -2026490314);
        } else {
            graphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - barThickAfterAnim, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -2026490314);
        }
        if (this.dir == Direction.VERTICAL) {
            graphics.m_280509_(this.m_252754_() + this.m_5711_() - barThickAfterAnim, this.m_252907_() + barOffset, this.m_252754_() + this.m_5711_(), this.m_252907_() + barOffset + this.barSize, -1);
        } else {
            graphics.m_280509_(this.m_252754_() + barOffset, this.m_252907_() + this.m_93694_() - barThickAfterAnim, this.m_252754_() + barOffset + this.barSize, this.m_252907_() + this.m_93694_(), -1);
        }
    }

    protected void m_7212_(double mouseX, double mouseY, double dY, double dX) {
        double offset;
        this.holdInflate = true;
        if (!this.checkAndHandleMouseOutBound(mouseX, mouseY)) {
            return;
        }
        double d = offset = this.dir == Direction.VERTICAL ? dX : dY;
        if (offset == 0.0) {
            return;
        }
        this.offsetBar(offset);
        this.onValueUpdated();
    }

    private boolean checkAndHandleMouseOutBound(double mouseX, double mouseY) {
        if (mouseX < (double)this.m_252754_()) {
            if (this.barOffset > 0.0) {
                this.setBarOffset(0.0);
                this.onValueUpdated();
            }
            return false;
        }
        if (mouseX > (double)(this.m_252754_() + this.f_93618_)) {
            if (this.barOffset < (double)this.getMaxOffsetValue()) {
                this.setBarOffset(this.getMaxOffsetValue());
                this.onValueUpdated();
            }
            return false;
        }
        return true;
    }

    private void offsetBar(double offset) {
        this.barOffset = Mth.m_14008_((double)(this.barOffset + offset), (double)0.0, (double)this.getMaxOffsetValue());
    }

    public void setBarOffset(double offset) {
        this.barOffset = Mth.m_14008_((double)offset, (double)0.0, (double)this.getMaxOffsetValue());
    }

    public int getMaxOffsetValue() {
        return this.dir == Direction.VERTICAL ? this.f_93619_ - this.barSize : this.f_93618_ - this.barSize;
    }

    public double getProgressValue() {
        int maxOffset = this.getMaxOffsetValue();
        if (maxOffset <= 0) {
            return 0.0;
        }
        return this.barOffset / (double)maxOffset;
    }

    public void onValueUpdated() {
    }

    public void setBarSize(int size) {
        this.barSize = size;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

