/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.store.slice;

import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.store.UIActionTypes;
import doggytalents.client.screen.DogNewInfoScreen.store.payload.ChangeTabPayload;
import doggytalents.client.screen.DogNewInfoScreen.store.payload.InitSkinIndexPayload;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveSkinSlice;
import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.CommonUIActionTypes;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogGroupsData;
import doggytalents.common.network.packet.data.StatsSyncData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.network.PacketDistributor;

public class ActiveTabSlice
implements AbstractSlice {
    @Override
    public Object getInitalState() {
        return new Object();
    }

    @Override
    public Object reducer(Object oldData, UIAction action) {
        Object object;
        if ((action.type == CommonUIActionTypes.CHANGE_TAB || action.type == CommonUIActionTypes.SWITCH_TAB) && (object = action.payload) instanceof ChangeTabPayload) {
            ChangeTabPayload tabPayload = (ChangeTabPayload)object;
            return tabPayload.getTab();
        }
        return oldData;
    }

    public static UIAction UIActionCreator(Dog dog, Tab tab, String type) {
        ChangeTabPayload payload = new ChangeTabPayload(tab);
        if (tab == Tab.STATS) {
            ActiveTabSlice.setupStats(dog);
        } else if (tab == Tab.STYLE) {
            payload = ActiveTabSlice.setupSkins(dog);
        } else if (tab == Tab.HOME) {
            ActiveTabSlice.setupGroups(dog);
        }
        return new UIAction(type, payload);
    }

    public static Tab getPrevTab(Tab tab) {
        switch (tab) {
            case HOME: {
                return Tab.STATS;
            }
            case STATS: {
                return Tab.STYLE;
            }
            case STYLE: {
                return Tab.TALENTS;
            }
            case TALENTS: {
                return Tab.HOME;
            }
        }
        return Tab.HOME;
    }

    public static Tab getNextTab(Tab tab) {
        switch (tab) {
            case HOME: {
                return Tab.TALENTS;
            }
            case STATS: {
                return Tab.HOME;
            }
            case STYLE: {
                return Tab.STATS;
            }
            case TALENTS: {
                return Tab.STYLE;
            }
        }
        return Tab.HOME;
    }

    private static void setupStats(Dog dog) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new StatsSyncData.Request(dog.m_19879_()));
    }

    private static InitSkinIndexPayload setupSkins(Dog dog) {
        ActiveSkinSlice.initLocList();
        return new InitSkinIndexPayload(Tab.STYLE, dog);
    }

    private static void setupGroups(Dog dog) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogGroupsData.FETCH_REQUEST(dog.m_19879_()));
    }

    public static void dispatchGroupUpdates() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof DogNewInfoScreen) {
            DogNewInfoScreen dogInfoScreen = (DogNewInfoScreen)screen;
            Store.get(dogInfoScreen).dispatch(ActiveTabSlice.class, new UIAction(UIActionTypes.DOG_GROUPS_RESPONSE, new Object()));
        }
    }

    public static enum Tab {
        HOME("home"),
        TALENTS("talents"),
        STYLE("style"),
        STATS("stats");

        public final String unlocalizedTitle;

        private Tab(String title) {
            this.unlocalizedTitle = "doggui.navbar." + title;
        }
    }
}

