/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.TalentView;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.DogStatusViewBoxElement;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveTalentDescSlice;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.TalentChangeHandlerSlice;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.DivElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ScrollView;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.client.screen.framework.widget.OneLineLimitedTextArea;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.network.packet.data.DoggyToolsPickFirstData;
import doggytalents.common.network.packet.data.DoggyTorchData;
import doggytalents.common.network.packet.data.GatePasserData;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import doggytalents.common.network.packet.data.PackPuppyData;
import doggytalents.common.network.packet.data.RescueDogRenderData;
import doggytalents.common.talent.DoggyTorchTalent;
import doggytalents.common.talent.GatePasserTalent;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.talent.RescueDogTalent;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class TalentInfoViewElement
extends AbstractElement {
    Dog dog;
    Talent talent;
    Font font;
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;

    public TalentInfoViewElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.f_91062_;
    }

    @Override
    public AbstractElement init() {
        Talent talent;
        this.getStateAndSubscribesTo(TalentChangeHandlerSlice.class, TalentChangeHandlerSlice.class, null);
        this.talent = talent = this.getStateAndSubscribesTo(ActiveTalentDescSlice.class, ActiveTalentDescSlice.class, new ActiveTalentDescSlice(null)).activeTalent;
        if (this.talent == null) {
            return this;
        }
        if (!DogUtil.playerCanTrainTalent((Player)Minecraft.m_91087_().f_91074_, talent) || !talent.isDogEligible(this.dog)) {
            return this;
        }
        this.addTrainButton(this.dog);
        this.addTitleAndDescriptionView(talent);
        return this;
    }

    private void addTitleAndDescriptionView(Talent talent) {
        ScrollView scrollView = new ScrollView(this, this.getScreen());
        scrollView.setPosition(ElementPosition.PosType.ABSOLUTE, 5, 0).setSize(1.0f, this.getSizeY() - 65).init();
        this.addChildren((GuiEventListener)scrollView);
        AbstractElement container = scrollView.getContainer();
        container.addChildren((GuiEventListener)new TalentTitleAndDescEntry(container, this.getScreen(), talent).init());
        this.addTalentSpecificOptions(container, talent);
    }

    private void addTalentSpecificOptions(AbstractElement container, Talent talent) {
        if (talent == DoggyTalents.PACK_PUPPY.get()) {
            this.addRenderPackPuppyButton(this.dog, container);
            AbstractElement packPuppyButtonDiv = new PackPuppyButtonDiv(container, this.getScreen(), this.dog).setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 20).init();
            container.addChildren((GuiEventListener)packPuppyButtonDiv);
        } else if (talent == DoggyTalents.DOGGY_TORCH.get()) {
            Optional talentInstOptional = this.dog.getTalent((Supplier)DoggyTalents.DOGGY_TORCH);
            if (!talentInstOptional.isPresent()) {
                return;
            }
            TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
            if (!(talentInst instanceof DoggyTorchTalent)) {
                return;
            }
            DoggyTorchTalent torchTalent = (DoggyTorchTalent)talentInst;
            AbstractElement torchButtonDiv = new DivElement(container, this.getScreen()).setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 30).init();
            container.addChildren((GuiEventListener)torchButtonDiv);
            MutableComponent torchButtonStr = Component.m_237115_((String)(torchTalent.placingTorch() ? "talent.doggytalents.doggy_tools.placing_torch.unset" : "talent.doggytalents.doggy_tools.placing_torch.set"));
            FlatButton torchButton = new FlatButton(torchButtonDiv.getRealX() + 5, torchButtonDiv.getRealY() + 5, 120, 20, (Component)torchButtonStr, b -> {
                boolean newVal = !torchTalent.placingTorch();
                b.m_93666_((Component)Component.m_237115_((String)(newVal ? "talent.doggytalents.doggy_tools.placing_torch.unset" : "talent.doggytalents.doggy_tools.placing_torch.set")));
                torchTalent.setPlacingTorch(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DoggyTorchData(this.dog.m_19879_(), newVal));
            });
            torchButtonDiv.addChildren((GuiEventListener)torchButton);
            if (torchTalent.canRenderTorch()) {
                container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + torchTalent.renderTorch())), b -> {
                    Boolean newVal = !torchTalent.renderTorch();
                    b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                    torchTalent.setRenderTorch(newVal);
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new DoggyTorchData(this.dog.m_19879_(), newVal, DoggyTorchData.Type.RENDER_TORCH));
                }), I18n.m_118938_((String)"talent.doggytalents.doggy_torch.render_torch", (Object[])new Object[0])).init());
            }
        } else if (talent == DoggyTalents.DOGGY_TOOLS.get()) {
            Optional talentOptional = this.dog.getTalent((Supplier)DoggyTalents.DOGGY_TOOLS);
            if (!talentOptional.isPresent()) {
                return;
            }
            TalentInstance talentInst = (TalentInstance)talentOptional.get();
            if (!(talentInst instanceof DoggyToolsTalent)) {
                return;
            }
            DoggyToolsTalent toolsTalent = (DoggyToolsTalent)talentInst;
            container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + toolsTalent.pickFirstTool())), b -> {
                Boolean newVal = !toolsTalent.pickFirstTool();
                b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                toolsTalent.setPickFirstTool(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DoggyToolsPickFirstData(this.dog.m_19879_(), newVal));
            }), I18n.m_118938_((String)"talent.doggytalents.doggy_tools.pick_first_tool", (Object[])new Object[0])).init());
            AbstractElement toolsButtonDiv = new DivElement(container, this.getScreen()).setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 30).init();
            container.addChildren((GuiEventListener)toolsButtonDiv);
            MutableComponent toolButtonStr = Component.m_237115_((String)"talent.doggytalents.doggy_tools.open_tools");
            FlatButton toolButton = new FlatButton(toolsButtonDiv.getRealX() + 5, toolsButtonDiv.getRealY() + 5, 120, 20, (Component)toolButtonStr, b -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData(OpenDogScreenData.ScreenType.TOOL, this.dog.m_19879_())));
            toolsButtonDiv.addChildren((GuiEventListener)toolButton);
        } else if (talent == DoggyTalents.DOGGY_ARMOR.get()) {
            if (this.dog.getDogLevel((Supplier)DoggyTalents.DOGGY_ARMOR) <= 0) {
                return;
            }
            AbstractElement armorButtonDiv = new DivElement(container, this.getScreen()).setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 30).init();
            container.addChildren((GuiEventListener)armorButtonDiv);
            MutableComponent armorButtonStr = Component.m_237115_((String)"talent.doggytalents.doggy_armor.open_armor");
            FlatButton armorButton = new FlatButton(armorButtonDiv.getRealX() + 5, armorButtonDiv.getRealY() + 5, 120, 20, (Component)armorButtonStr, b -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData(OpenDogScreenData.ScreenType.ARMOR, this.dog.m_19879_())));
            armorButtonDiv.addChildren((GuiEventListener)armorButton);
        } else if (talent == DoggyTalents.RESCUE_DOG.get()) {
            Optional talentInstOptional = this.dog.getTalent((Supplier)DoggyTalents.RESCUE_DOG);
            if (!talentInstOptional.isPresent()) {
                return;
            }
            TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
            if (!(talentInst instanceof RescueDogTalent)) {
                return;
            }
            RescueDogTalent rescue = (RescueDogTalent)talentInst;
            container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + rescue.renderBox())), b -> {
                Boolean newVal = !rescue.renderBox();
                b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                rescue.setRenderBox(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new RescueDogRenderData(this.dog.m_19879_(), newVal));
            }), I18n.m_118938_((String)"talent.doggytalents.rescue_dog.render_box", (Object[])new Object[0])).init());
        } else if (talent == DoggyTalents.GATE_PASSER.get()) {
            Optional talentInstOptional = this.dog.getTalent((Supplier)DoggyTalents.GATE_PASSER);
            if (!talentInstOptional.isPresent()) {
                return;
            }
            TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
            if (!(talentInst instanceof GatePasserTalent)) {
                return;
            }
            GatePasserTalent gateTalent = (GatePasserTalent)talentInst;
            AbstractElement gateButtonDiv = new DivElement(container, this.getScreen()).setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 30).init();
            container.addChildren((GuiEventListener)gateButtonDiv);
            MutableComponent gateButtonStr = Component.m_237115_((String)(gateTalent.allowPassingGate() ? "talent.doggytalents.gate_passer.pass_gate.unset" : "talent.doggytalents.gate_passer.pass_gate.set"));
            FlatButton gateButton = new FlatButton(gateButtonDiv.getRealX() + 5, gateButtonDiv.getRealY() + 5, 120, 20, (Component)gateButtonStr, b -> {
                boolean newVal = !gateTalent.allowPassingGate();
                b.m_93666_((Component)Component.m_237115_((String)(newVal ? "talent.doggytalents.gate_passer.pass_gate.unset" : "talent.doggytalents.gate_passer.pass_gate.set")));
                gateTalent.setAllowPassingGate(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new GatePasserData(this.dog.m_19879_(), newVal));
            });
            gateButtonDiv.addChildren((GuiEventListener)gateButton);
        }
    }

    private void addRenderPackPuppyButton(Dog dog, AbstractElement container) {
        Optional talentInstOptional = dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof PackPuppyTalent)) {
            return;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)talentInst;
        container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + packPup.renderChest())), b -> {
            Boolean newVal = !packPup.renderChest();
            b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
            packPup.setRenderChest(newVal);
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PackPuppyData(dog.m_19879_(), PackPuppyData.Type.RENDER_CHEST, newVal));
        }), I18n.m_118938_((String)"talent.doggytalents.pack_puppy.render_chest", (Object[])new Object[0])).init());
        if (packPup.canCollectItems()) {
            container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + packPup.pickupItems())), b -> {
                Boolean newVal = !packPup.pickupItems();
                b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                packPup.setPickupItems(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PackPuppyData(dog.m_19879_(), PackPuppyData.Type.PICKUP_NEARBY, newVal));
            }), I18n.m_118938_((String)"talent.doggytalents.pack_puppy.pickup_item", (Object[])new Object[0])).init());
            container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + packPup.collectKillLoot())), b -> {
                Boolean newVal = !packPup.collectKillLoot();
                b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                packPup.setCollectKillLoot(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PackPuppyData(dog.m_19879_(), PackPuppyData.Type.COLLECT_KILL_LOOT, newVal));
            }){

                public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                    super.m_88315_(graphics, mouseX, mouseY, pTicks);
                    if (!this.f_93622_) {
                        return;
                    }
                    MutableComponent c1 = Component.m_237115_((String)"talent.doggytalents.pack_puppy.collect_kill_loot.desc");
                    ToolTipOverlayManager.get().setComponents(List.of(c1));
                }
            }, I18n.m_118938_((String)"talent.doggytalents.pack_puppy.collect_kill_loot", (Object[])new Object[0])).init());
        }
        if (packPup.canOfferFood()) {
            container.addChildren((GuiEventListener)new ButtonOptionEntry(container, this.getScreen(), (AbstractWidget)new FlatButton(0, 0, 40, 20, (Component)Component.m_237113_((String)("" + packPup.offerFood())), b -> {
                Boolean newVal = !packPup.offerFood();
                b.m_93666_((Component)Component.m_237113_((String)("" + newVal)));
                packPup.setOfferFood(newVal);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PackPuppyData(dog.m_19879_(), PackPuppyData.Type.OFFER_FOOD, newVal));
            }), I18n.m_118938_((String)"talent.doggytalents.pack_puppy.offer_food", (Object[])new Object[0])).init());
        }
    }

    private void addTrainButton(final Dog dog) {
        int dogLevel = dog.getDogLevel(this.talent);
        var trainButton = new CustomButton(0, 0, 50, 20, (Component)Component.m_237115_((String)"doggui.talents.train"), b -> this.requestTrain()){

            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                int costStrColor;
                Object costStr;
                super.m_87963_(graphics, mouseX, mouseY, pTicks);
                int tX = this.m_252754_();
                int n = this.m_252907_() - 3;
                Objects.requireNonNull(TalentInfoViewElement.this.font);
                int tY = n - 9;
                int dogLevel = dog.getDogLevel(TalentInfoViewElement.this.talent);
                if (dogLevel >= TalentInfoViewElement.this.talent.getMaxLevel()) {
                    costStr = I18n.m_118938_((String)"doggui.talents.max_level", (Object[])new Object[0]);
                    costStrColor = -721152;
                } else {
                    costStr = I18n.m_118938_((String)"doggui.talents.cost", (Object[])new Object[0]) + TalentInfoViewElement.this.talent.getLevelCost(dogLevel + 1);
                    costStrColor = -1;
                }
                graphics.m_280488_(TalentInfoViewElement.this.font, (String)costStr, tX, tY, costStrColor);
                this.f_93623_ = dogLevel < TalentInfoViewElement.this.talent.getMaxLevel() && dog.canSpendPoints(TalentInfoViewElement.this.talent.getLevelCost(dogLevel + 1));
            }

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                if (this.f_93623_) {
                    return;
                }
                if (dog.getDogLevel(TalentInfoViewElement.this.talent) >= TalentInfoViewElement.this.talent.getMaxLevel()) {
                    return;
                }
                MutableComponent c1 = Component.m_237115_((String)"doggui.talents.insufficent_points");
                c1.m_6270_(Style.f_131099_.m_178520_(-5111808).m_131136_(Boolean.valueOf(true)));
                ToolTipOverlayManager.get().setComponents(List.of(c1));
            }
        };
        trainButton.f_93623_ = dogLevel < this.talent.getMaxLevel() && dog.canSpendPoints(this.talent.getLevelCost(dogLevel + 1));
        int trainButtonX = this.getRealX() + this.getSizeX() - trainButton.m_5711_() - 35;
        int trainButtonY = this.getRealY() + this.getSizeY() - trainButton.m_93694_() - 20;
        trainButton.m_252865_(trainButtonX);
        trainButton.m_253211_(trainButtonY);
        this.addChildren((GuiEventListener)trainButton);
        OneLineLimitedTextArea pointsLeftStr = new OneLineLimitedTextArea(0, 0, 75, (Component)Component.m_237115_((String)"doggui.pointsleft"));
        pointsLeftStr.m_252865_(this.getRealX() + 5 + 40);
        pointsLeftStr.m_253211_(this.getRealY() + this.getSizeY() - 45);
        this.addChildren((GuiEventListener)pointsLeftStr);
    }

    private void requestTrain() {
        int level = this.dog.getDogLevel(this.talent);
        if (level < this.talent.getMaxLevel() && this.dog.canSpendPoints(this.talent.getLevelCost(level + 1))) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTalentData(this.dog.m_19879_(), this.talent));
        }
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.talent == null) {
            int mX = this.getSizeX() / 2;
            int mY = this.getSizeY() / 2;
            String txt = I18n.m_118938_((String)"doggui.talents.no_talents_selected", (Object[])new Object[0]);
            int tX = this.getRealX() + mX - this.font.m_92895_(txt) / 2;
            int n = this.getRealY() + mY;
            Objects.requireNonNull(this.font);
            int tY = n - 9 / 2;
            graphics.m_280488_(this.font, txt, tX, tY, -1);
            return;
        }
        if (!DogUtil.playerCanTrainTalent((Player)Minecraft.m_91087_().f_91074_, this.talent)) {
            int mX = this.getSizeX() / 2;
            int mY = this.getSizeY() / 2;
            MutableComponent txt = Component.m_237115_((String)"doggui.talents.invalid.disabled");
            txt.m_6270_(Style.f_131099_.m_178520_(-5111808).m_131136_(Boolean.valueOf(true)));
            int tX = this.getRealX() + mX - this.font.m_92852_((FormattedText)txt) / 2;
            int n = this.getRealY() + mY;
            Objects.requireNonNull(this.font);
            int tY = n - 9 / 2;
            graphics.m_280430_(this.font, (Component)txt, tX, tY, -1);
            return;
        }
        if (!this.talent.isDogEligible(this.dog)) {
            int mX = this.getSizeX() / 2;
            int mY = this.getSizeY() / 2;
            Optional<String> non_eligbleMsgOptional = this.talent.getNonEligibleTranslationKey(this.dog);
            MutableComponent txt = Component.m_237115_((String)non_eligbleMsgOptional.orElse("doggui.talents.invalid.not_eligible"));
            txt.m_6270_(Style.f_131099_.m_178520_(0x828282));
            int tX = this.getRealX() + mX - this.font.m_92852_((FormattedText)txt) / 2;
            int n = this.getRealY() + mY;
            Objects.requireNonNull(this.font);
            int tY = n - 9 / 2;
            graphics.m_280430_(this.font, (Component)txt, tX, tY, -1);
            return;
        }
        int startX = this.getRealX() + 5;
        int startY = this.getRealY() + 5;
        int pX = startX;
        int pY = startY;
        startX = this.getRealX() + 5;
        pY = this.getRealY() + this.getSizeY() - 60;
        this.drawDogLevelKanji(graphics, startX, pY, 50);
        startX = this.getRealX() + 5 + 40;
        pY = this.getRealY() + this.getSizeY() - 45;
        String currentLevelStr = "";
        String currentLevelStr1 = "" + this.dog.getSpendablePoints();
        Objects.requireNonNull(this.font);
        graphics.m_280488_(this.font, currentLevelStr1, startX, pY += 9 + 3, -1);
        startX = this.getRealX() + 80 + 40;
        pY = this.getRealY() + this.getSizeY() - 45;
        currentLevelStr = I18n.m_118938_((String)"doggui.talents.current_talent_level", (Object[])new Object[0]);
        currentLevelStr1 = this.dog.getDogLevel(this.talent) + "/" + this.talent.getMaxLevel();
        graphics.m_280488_(this.font, currentLevelStr, startX, pY, -1);
        Objects.requireNonNull(this.font);
        graphics.m_280488_(this.font, currentLevelStr1, startX, pY += 9 + 3, -1);
    }

    private void drawDogLevelKanji(GuiGraphics graphics, int x, int y, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = size;
        graphics.m_280398_(DogStatusViewBoxElement.getKanjiDogLevel(this.dog), x, y, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        RenderSystem.disableBlend();
    }

    public static class TalentTitleAndDescEntry
    extends AbstractElement {
        private Talent talent;
        private Component title;
        private List<FormattedCharSequence> descriptionLines;
        private Font font;

        public TalentTitleAndDescEntry(AbstractElement parent, Screen screen, Talent talent) {
            super(parent, screen);
            this.talent = talent;
            this.font = Minecraft.m_91087_().f_91062_;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.title = Component.m_237115_((String)this.talent.getTranslationKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(-721152));
            MutableComponent content = Component.m_237115_((String)this.talent.getInfoTranslationKey());
            this.descriptionLines = this.font.m_92923_((FormattedText)content, this.getParent().getSizeX() - 20);
            Objects.requireNonNull(this.font);
            int n = this.descriptionLines.size();
            Objects.requireNonNull(this.font);
            int totalH = 3 + 9 + 3 + n * (3 + 9) + 3;
            this.setSize(1.0f, totalH);
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int pX = this.getRealX();
            int pY = this.getRealY() + 3;
            graphics.m_280430_(this.font, this.title, pX, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
            for (FormattedCharSequence line : this.descriptionLines) {
                graphics.m_280648_(this.font, line, pX, pY, -1);
                Objects.requireNonNull(this.font);
                pY += 9 + 3;
            }
        }
    }

    private static class PackPuppyButtonDiv
    extends AbstractElement {
        private DogInventoryButton button;
        private Dog dog;

        public PackPuppyButtonDiv(AbstractElement parent, Screen screen, Dog dog) {
            super(parent, screen);
            this.dog = dog;
        }

        @Override
        public AbstractElement init() {
            this.button = new DogInventoryButton(this.getRealX() + 5, this.getRealY() + 5, this.getScreen(), this.dog);
            this.addChildren((GuiEventListener)this.button);
            return this;
        }

        @Override
        public void onGlobalKeyPress(int keyCode, int scanCode, int modifiers) {
            this.button.keyGlobalPressed(keyCode, scanCode, modifiers);
        }

        @Override
        public void onGlobalKeyRelease(int keyCode, int scanCode, int modifiers) {
            this.button.keyGlobalReleased(keyCode, scanCode, modifiers);
        }
    }

    private static class ButtonOptionEntry
    extends AbstractElement {
        private AbstractWidget button;
        private String label;
        private Font font;
        private boolean newline = false;

        public ButtonOptionEntry(AbstractElement parent, Screen screen, AbstractWidget button, String label) {
            super(parent, screen);
            this.font = Minecraft.m_91087_().f_91062_;
            this.button = button;
            this.label = label;
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.RELATIVE, 0, 0);
            this.setSize(1.0f, 23);
            int buttonX_offset = 135;
            int buttonY_offset = this.getSizeY() / 2 - this.button.m_93694_() / 2 + 1;
            AbstractElement p = this.getParent();
            if (p != null && buttonX_offset + this.button.m_5711_() > p.getSizeX()) {
                this.newline = true;
                buttonX_offset = 5;
                buttonY_offset += 14;
            }
            if (this.newline) {
                this.setSize(1.0f, 37);
            }
            this.button.m_252865_(this.getRealX() + buttonX_offset);
            this.button.m_253211_(this.getRealY() + buttonY_offset);
            this.addChildren((GuiEventListener)this.button);
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.newline) {
                int startX = this.getRealX() + 5;
                int pY = this.getRealY() + 3;
                graphics.m_280488_(this.font, this.label, startX, pY, -1);
                return;
            }
            int startX = this.getRealX() + 5;
            int n = this.getRealY() + this.getSizeY() / 2;
            Objects.requireNonNull(this.font);
            int pY = n - 9 / 2;
            graphics.m_280488_(this.font, this.label, startX, pY, -1);
        }
    }
}

