/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ConductingBoneData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class ConductingBoneScreen
extends Screen {
    private Rect2i rect;
    private Player player;
    private final ArrayList<String> dogNameList;
    private final ArrayList<UUID> dogIdList;
    private final ArrayList<String> dogNameFilterList;
    private final ArrayList<UUID> dogIdFilterList;
    private int hightLightDogNamePerPage;
    private boolean showUuid = false;
    private String value = "";
    private boolean toBed = false;
    private int maxPages = 1;
    private int pageNumber = 0;
    private final int MAX_PAGES_ENTRIES = 19;
    private TextOnlyButton prevPageButton;
    private TextOnlyButton nextPageButton;
    private final int HLC_HEEL_NO_SIT = 16716025;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;
    private int hightlightTextColor = 16716025;
    private final int MAX_BUFFER_SIZE = 64;
    private int mouseX0;
    private int mouseY0;

    public ConductingBoneScreen(Player player) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.conducting_bone"));
        this.player = player;
        this.dogNameList = new ArrayList(4);
        this.dogIdList = new ArrayList(4);
        this.dogIdFilterList = new ArrayList(4);
        this.dogNameFilterList = new ArrayList(4);
        this.hightLightDogNamePerPage = 0;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        ConductingBoneScreen screen = new ConductingBoneScreen((Player)mc.f_91074_);
        if (mc.f_91074_ != null && mc.f_91074_.m_6144_()) {
            screen.toBed = true;
        }
        mc.m_91152_((Screen)screen);
        screen.requestDogs();
    }

    public void m_7856_() {
        super.m_7856_();
        this.rect = new Rect2i(0, 0, 500, 500);
        CustomButton showUuid = new CustomButton(3, 3, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        CustomButton help = new CustomButton(3, 26, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.conducting_bone.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.conducting_bone.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, ConductingBoneScreen.this.f_96547_));
                graphics.m_280666_(ConductingBoneScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        CustomButton toBedButton = new CustomButton(3, 49, 60, 20, (Component)Component.m_237113_((String)(this.toBed ? "To Bed" : "To Self")), b -> {
            if (this.toBed) {
                this.toBed = false;
                b.m_93666_((Component)Component.m_237113_((String)"To Self"));
            } else {
                this.toBed = true;
                b.m_93666_((Component)Component.m_237113_((String)"To Bed"));
            }
        });
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)toBedButton);
        this.addPageButtons();
    }

    private void addPageButtons() {
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        TextOnlyButton prevPage = new TextOnlyButton(half_width - 120, half_height - 10, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
            this.pageNumber = Math.max(0, this.pageNumber - 1);
            this.hightLightDogNamePerPage = 0;
        }, this.f_96547_);
        TextOnlyButton nextPage = new TextOnlyButton(half_width + 100, half_height - 10, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
            this.pageNumber = Math.min(this.maxPages - 1, this.pageNumber + 1);
            this.hightLightDogNamePerPage = 0;
        }, this.f_96547_);
        prevPage.f_93623_ = this.pageNumber > 0;
        nextPage.f_93623_ = this.pageNumber < this.maxPages - 1;
        this.prevPageButton = prevPage;
        this.nextPageButton = nextPage;
        this.m_142416_((GuiEventListener)prevPage);
        this.m_142416_((GuiEventListener)nextPage);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.mouseX0 != mouseX || this.mouseY0 != mouseY) {
            this.onMouseMoved(mouseX, mouseY);
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }
        int half_width = this.f_96543_ >> 1;
        int half_height = this.f_96544_ >> 1;
        graphics.m_280509_(half_width - 100, half_height - 100, half_width + 100, half_height + 100, Integer.MIN_VALUE);
        graphics.m_280509_(half_width - 100, half_height + 105, half_width + 100, half_height + 117, Integer.MIN_VALUE);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int offset = 0;
        int textx = half_width - 100 + 2;
        int texty = half_height - 100 + 2;
        if (this.dogNameFilterList.size() <= 0) {
            graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), textx, texty + offset, 16058890);
        }
        int startIndx = this.pageNumber * 19;
        int drawNo = 0;
        for (int i = startIndx; i < this.dogNameFilterList.size(); ++i) {
            int color = -1;
            if (i == this.pageNumber * 19 + this.hightLightDogNamePerPage) {
                color = this.hightlightTextColor;
            }
            String text = this.dogNameFilterList.get(i) + (String)(this.showUuid ? " ( " + this.dogIdFilterList.get(i) + " ) " : "");
            graphics.m_280488_(this.f_96547_, text, textx, texty + offset, color);
            offset += 10;
            if (++drawNo >= 19) break;
        }
        int txtorgx = half_width - 90;
        int txtorgy = half_height + 107;
        graphics.m_280488_(this.f_96547_, this.value + "_", txtorgx, txtorgy, -1);
        String pageStr = this.pageNumber + 1 + "/" + this.maxPages;
        int pageStrWidth = this.f_96547_.m_92895_(pageStr);
        graphics.m_280488_(this.f_96547_, pageStr, half_width - pageStrWidth / 2, half_height - 110, -1);
        this.prevPageButton.f_93623_ = this.pageNumber > 0;
        this.nextPageButton.f_93623_ = this.pageNumber < this.maxPages - 1;
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return -1;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return -1;
        }
        int baseY = mY - 100;
        int indx = Mth.m_14107_((double)(y - (double)baseY)) / 10;
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private void onMouseMoved(double x, double y) {
        int newIndx = this.getHoveredIndex(x, y, this.getCurrentPageEntries());
        if (newIndx < 0) {
            return;
        }
        this.hightLightDogNamePerPage = newIndx;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        boolean ret = super.m_6375_(x, y, p_94697_);
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        if (Math.abs(x - (double)mX) > 100.0) {
            return ret;
        }
        if (Math.abs(y - (double)mY) > 100.0) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.getCurrentPageEntries());
        if ((indx += this.pageNumber * 19) >= 0 && indx < this.dogIdFilterList.size()) {
            this.requestDistantTeleport(this.dogIdFilterList.get(indx));
            Minecraft.m_91087_().m_91152_(null);
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            int currentPageEntries = this.getCurrentPageEntries() - 1;
            this.hightLightDogNamePerPage = Mth.m_14045_((int)(this.hightLightDogNamePerPage + 1), (int)0, (int)currentPageEntries);
            return true;
        }
        if (keyCode == 265) {
            int currentPageEntries = this.getCurrentPageEntries() - 1;
            this.hightLightDogNamePerPage = Mth.m_14045_((int)(this.hightLightDogNamePerPage - 1), (int)0, (int)currentPageEntries);
            return true;
        }
        if (keyCode == 263) {
            if (this.prevPageButton.f_93623_) {
                this.prevPageButton.m_5716_(0.0, 0.0);
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.nextPageButton.f_93623_) {
                this.nextPageButton.m_5716_(0.0, 0.0);
            }
            return true;
        }
        if (keyCode == 257) {
            if (this.dogIdFilterList.isEmpty()) {
                return false;
            }
            int selectedId = this.getSelectedId();
            if (selectedId >= 0 && selectedId < this.dogIdFilterList.size()) {
                this.requestDistantTeleport(this.dogIdFilterList.get(selectedId));
                this.f_96541_.m_91152_(null);
            }
            return true;
        }
        if (keyCode == 259) {
            this.popCharInText();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private int getCurrentPageEntries() {
        if (this.pageNumber >= this.maxPages - 1) {
            return this.dogIdFilterList.size() % 19;
        }
        return 19;
    }

    private int getSelectedId() {
        return this.pageNumber * 19 + this.hightLightDogNamePerPage;
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        if (SharedConstants.m_136188_((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    private void updateFilter() {
        this.dogNameFilterList.clear();
        this.dogIdFilterList.clear();
        this.hightLightDogNamePerPage = 0;
        if (this.value == "") {
            for (String string : this.dogNameList) {
                this.dogNameFilterList.add(string);
            }
            for (UUID uUID : this.dogIdList) {
                this.dogIdFilterList.add(uUID);
            }
        } else {
            for (int i = 0; i < this.dogIdList.size(); ++i) {
                if (this.dogNameList.get(i).length() < this.value.length() || !this.dogNameList.get(i).contains(this.value)) continue;
                this.dogIdFilterList.add(this.dogIdList.get(i));
                this.dogNameFilterList.add(this.dogNameList.get(i));
            }
        }
        this.updatePages();
    }

    private void updatePages() {
        int dogNumbers = this.dogIdFilterList.size();
        this.maxPages = 1 + dogNumbers / 19;
        this.pageNumber = 0;
        this.hightLightDogNamePerPage = 0;
    }

    private void insertText(String x) {
        if (this.value.length() < 64) {
            this.value = this.value + x;
        }
        this.updateFilter();
    }

    private void popCharInText() {
        if (this.value.length() <= 0) {
            return;
        }
        this.value = this.value.substring(0, this.value.length() - 1);
        this.updateFilter();
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDogsData());
    }

    private void requestDistantTeleport(UUID dogUuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDistantTeleportDogData(dogUuid, this.toBed));
    }

    public void assignResponse(List<Pair<UUID, String>> dogLs) {
        for (Pair<UUID, String> entry : dogLs) {
            this.dogNameList.add((String)entry.getRight());
            this.dogNameFilterList.add((String)entry.getRight());
            this.dogIdList.add((UUID)entry.getLeft());
            this.dogIdFilterList.add((UUID)entry.getLeft());
        }
        this.updatePages();
    }
}

