/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.skin;

import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.lib.Resources;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class DogSkin {
    public static final DogSkin CLASSICAL = new DogSkin(Resources.DOG_CLASSICAL){

        @Override
        public ResourceLocation getPath() {
            if (((Boolean)ConfigHandler.CLIENT.USE_VANILLA_RES_FOR_CLASSICAL.get()).booleanValue()) {
                return Resources.ENTITY_WOLF;
            }
            return super.getPath();
        }

        @Override
        public boolean hasExtraInfo() {
            return true;
        }

        @Override
        public String getDesc() {
            return "The Minecraft Wolf. DTN's Default Skin. Mhmmmm! Classy!";
        }

        @Override
        public String getTags() {
            return "default, classical";
        }
    }.setName("Classical");
    public static final DogSkin MISSING = new DogSkin(Resources.DOG_CLASSICAL){

        @Override
        public ResourceLocation getPath() {
            if (((Boolean)ConfigHandler.CLIENT.USE_VANILLA_RES_FOR_CLASSICAL.get()).booleanValue()) {
                return Resources.ENTITY_WOLF;
            }
            return super.getPath();
        }
    }.setName("<Missing>");
    public static final DogSkin MYSTERY = new DogSkin(Resources.DOG_MYSTERY){}.setName("<Mystery>");
    private String name = "";
    private ResourceLocation texturePath;
    private boolean useCustomModel;
    private DogModelRegistry.DogModelHolder customModelHolder;
    private byte tail = 0;
    private byte ear = 0;
    private boolean hasExtraInfo = false;
    private String basedOn = "";
    private String author = "";
    private String fromPack = "";
    private String description = "";
    private String tags = "";
    private boolean mystery = false;

    public DogSkin(ResourceLocation path) {
        this.texturePath = path;
        this.useCustomModel = false;
    }

    public DogSkin(ResourceLocation path, @Nonnull DogModelRegistry.DogModelHolder model) {
        this.texturePath = path;
        this.useCustomModel = true;
        this.customModelHolder = model;
    }

    public DogSkin setName(String s) {
        this.name = s == null ? "" : s;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setTail(byte val) {
        this.tail = val;
    }

    public byte getTail() {
        return this.tail;
    }

    public void setEar(byte val) {
        this.ear = val;
    }

    public byte getEar() {
        return this.ear;
    }

    public boolean useCustomModel() {
        return this.useCustomModel;
    }

    public DogModelRegistry.DogModelHolder getCustomModel() {
        return this.customModelHolder;
    }

    public ResourceLocation getPath() {
        return this.texturePath;
    }

    public void setAuthor(String author) {
        this.hasExtraInfo = true;
        this.author = author == null ? "" : author;
    }

    public void setBasedOn(String basedOn) {
        this.hasExtraInfo = true;
        this.basedOn = basedOn == null ? "" : basedOn;
    }

    public void setDesc(String desc) {
        this.hasExtraInfo = true;
        this.description = desc == null ? "" : desc;
    }

    public void setTags(String tags) {
        this.hasExtraInfo = true;
        this.tags = tags == null ? "" : tags;
    }

    public void setPack(String fromPack) {
        this.hasExtraInfo = true;
        this.fromPack = fromPack == null ? "" : fromPack;
    }

    public void setMystery(boolean val) {
        this.mystery = val;
    }

    public boolean hasExtraInfo() {
        return this.hasExtraInfo;
    }

    public String getBasedOn() {
        return this.basedOn;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getPack() {
        return this.fromPack;
    }

    public String getDesc() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean mystery() {
        return this.mystery;
    }
}

