/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.ForgeHooksClient;

public class DoggyArmorMapping {
    private static final Map<Item, ResourceLocation> LEGACY_MAPPING = new ImmutableMap.Builder().put((Object)Items.f_42468_, (Object)Resources.IRON_HELMET).put((Object)Items.f_42472_, (Object)Resources.DIAMOND_HELMET).put((Object)Items.f_42476_, (Object)Resources.GOLDEN_HELMET).put((Object)Items.f_42464_, (Object)Resources.CHAINMAIL_HELMET).put((Object)Items.f_42354_, (Object)Resources.TURTLE_HELMET).put((Object)Items.f_42480_, (Object)Resources.NETHERITE_HELMET).put((Object)Items.f_42471_, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.f_42475_, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.f_42479_, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.f_42467_, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42483_, (Object)Resources.NETHERITE_BODY_PIECE).put((Object)Items.f_42469_, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.f_42473_, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.f_42477_, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.f_42465_, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42481_, (Object)Resources.NETHERITE_BODY_PIECE).put((Object)Items.f_42407_, (Object)Resources.LEATHER_HELMET).put((Object)Items.f_42463_, (Object)Resources.LEATHER_BOOTS).put((Object)Items.f_42408_, (Object)Resources.LEATHER_BODY_PIECE).put((Object)Items.f_42462_, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.f_42470_, (Object)Resources.IRON_BODY_PIECE).put((Object)Items.f_42474_, (Object)Resources.DIAMOND_BODY_PIECE).put((Object)Items.f_42478_, (Object)Resources.GOLDEN_BODY_PIECE).put((Object)Items.f_42466_, (Object)Resources.CHAINMAIL_BODY_PIECE).put((Object)Items.f_42482_, (Object)Resources.NETHERITE_BODY_PIECE).build();
    private static Map<Item, ResourceLocation> MAPPING = Maps.newConcurrentMap();

    private static ResourceLocation computeArmorTexture(Item item, Dog dog, ItemStack stack) {
        String path;
        String s;
        if (!(item instanceof ArmorItem)) {
            return Resources.DEFAULT_DOG_ARMOR;
        }
        ArmorItem armor = (ArmorItem)item;
        Optional<ResourceLocation> preferedLocOptional = DoggyArmorMapping.computePreferedArmorLoc(item, dog, stack);
        if (preferedLocOptional.isPresent()) {
            return preferedLocOptional.get();
        }
        ResourceLocation armorLoc = new ResourceLocation(armor.m_40401_().m_6082_());
        String namespace = armorLoc.m_135827_();
        ResourceLocation computedRes = new ResourceLocation(namespace, s = "textures/models/armor/" + (path = armorLoc.m_135815_()) + "_layer_1.png");
        if (!ClientEventHandler.vertifyArmorTexture(computedRes)) {
            return Resources.DEFAULT_DOG_ARMOR;
        }
        return computedRes;
    }

    private static Optional<ResourceLocation> computePreferedArmorLoc(Item item, Dog dog, ItemStack stack) {
        String preferedLocStr = ForgeHooksClient.getArmorTexture((Entity)dog, (ItemStack)stack, (String)Resources.DEFAULT_DOG_ARMOR.toString(), (EquipmentSlot)EquipmentSlot.CHEST, null);
        ResourceLocation preferedLoc = new ResourceLocation(preferedLocStr);
        if (preferedLoc.equals((Object)Resources.DEFAULT_DOG_ARMOR)) {
            return Optional.empty();
        }
        if (!ClientEventHandler.vertifyArmorTexture(preferedLoc)) {
            return Optional.empty();
        }
        return Optional.ofNullable(preferedLoc);
    }

    public static ResourceLocation getMappedResource(Item item, Dog dog, ItemStack stack) {
        if (((Boolean)ConfigHandler.CLIENT.USE_LEGACY_DOG_ARMOR_RENDER.get()).booleanValue()) {
            return DoggyArmorMapping.getLegacyMappedResource(item);
        }
        return MAPPING.computeIfAbsent(item, x -> DoggyArmorMapping.computeArmorTexture(x, dog, stack));
    }

    public static ResourceLocation getLegacyMappedResource(Item item) {
        ResourceLocation x = LEGACY_MAPPING.get(item);
        if (x != null) {
            return x;
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)new ItemStack((ItemLike)item));
        switch (slot) {
            case CHEST: {
                return Resources.IRON_BODY_PIECE;
            }
            case FEET: {
                return Resources.IRON_BOOTS;
            }
            case HEAD: {
                return Resources.IRON_HELMET;
            }
            case LEGS: {
                return Resources.IRON_BODY_PIECE;
            }
        }
        return Resources.IRON_BODY_PIECE;
    }
}

