/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.KeyframeAnimationsDelegate;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class ElytraCapeModel
extends AnimatedSyncedAccessoryModel {
    public ModelPart flyingParts;
    public ModelPart rWing;
    public ModelPart lWing;
    public ModelPart elytra;
    private Vector3f vecObj = new Vector3f(0.0f, 0.0f, 0.0f);

    public ElytraCapeModel(ModelPart root) {
        super(root);
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.mane = Optional.of(box.m_171324_("upper_body"));
        this.flyingParts = ((ModelPart)this.mane.get()).m_171324_("elytra_rot");
        this.elytra = this.flyingParts.m_171324_("elytra");
        this.lWing = this.elytra.m_171324_("left_wing");
        this.rWing = this.elytra.m_171324_("right_wing");
    }

    @Override
    public Optional<ModelPart> searchForPartWithName(String name) {
        if (this.flyingParts.m_233562_(name)) {
            return Optional.of(this.flyingParts.m_171324_(name));
        }
        Optional<ModelPart> partOptional = this.flyingParts.m_171331_().filter(part -> part.m_233562_(name)).findFirst();
        return partOptional.map(part -> part.m_171324_(name));
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(dogIn, limbSwing, limbSwingAmount, partialTickTime);
        DogPose pose = dogIn.getDogPose();
        if (pose == DogPose.FLYING) {
            this.elytra.m_252899_(KeyframeAnimations.m_253186_((float)24.59f, (float)0.0f, (float)0.0f));
            this.elytra.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)-0.24f, (float)1.45f));
            this.rWing.m_252899_(KeyframeAnimations.m_253186_((float)-15.18f, (float)-46.68f, (float)11.36f));
            this.rWing.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
            this.lWing.m_252899_(KeyframeAnimations.m_253186_((float)-15.18f, (float)46.68f, (float)-11.36f));
            this.lWing.m_252854_(KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f));
        }
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogAnimationManager animationManager = dog.animationManager;
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(anim);
        if (sequence == null) {
            return;
        }
        if (animState.isStarted()) {
            KeyframeAnimationsDelegate.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    @Override
    public void resetAllPose() {
        this.elytra.m_233569_();
        this.lWing.m_233569_();
        this.rWing.m_233569_();
    }

    public static LayerDefinition cape() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition upper_body = partdefinition.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.m_171599_("elytra_rot", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.m_171599_("elytra", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape_r1 = elytra.m_171599_("cape_r1", CubeListBuilder.m_171558_().m_171514_(40, 42).m_171480_().m_171488_(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = elytra.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_r1 = right_wing.m_171599_("right_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-6.6851f, 3.7889f, 2.3232f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)-0.1309f, (float)0.0f));
        PartDefinition left_wing = elytra.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_r1 = left_wing.m_171599_("left_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-3.0f, (float)1.6144f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition bat() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition upper_body = partdefinition.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra_rot = upper_body.m_171599_("elytra_rot", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-3.75f, (float)-0.25f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition elytra = elytra_rot.m_171599_("elytra", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape_r1 = elytra.m_171599_("cape_r1", CubeListBuilder.m_171558_().m_171514_(40, 42).m_171480_().m_171488_(-2.8914f, 3.8079f, 2.3224f, 10.0f, 20.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-1.0f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = elytra.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)2.0f));
        PartDefinition left_wing_r1 = left_wing.m_171599_("left_wing_r1", CubeListBuilder.m_171558_().m_171514_(20, 47).m_171480_().m_171488_(0.6329f, -8.4717f, 18.5f, 10.0f, 16.0f, 1.0f, new CubeDeformation(0.001f)).m_171555_(false).m_171514_(0, 51).m_171480_().m_171488_(10.6329f, -7.4717f, 18.5f, 8.0f, 12.0f, 1.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)12.75f, (float)1.25f, (float)1.5708f, (float)-1.1345f, (float)0.0f));
        PartDefinition right_wing = elytra.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)2.0f));
        PartDefinition right_wing_r1 = right_wing.m_171599_("right_wing_r1", CubeListBuilder.m_171558_().m_171514_(20, 47).m_171488_(-10.6329f, -8.4717f, 18.5f, 10.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-18.6329f, -7.4717f, 18.5f, 8.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)12.75f, (float)1.25f, (float)1.5708f, (float)1.1345f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

