/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyTalentsNext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;

public class CachedFileTexture
extends SimpleTexture {
    private File cacheFile;
    private boolean textureUploaded;

    public CachedFileTexture(ResourceLocation rlIn, File cacheFileIn) {
        super(rlIn);
        this.cacheFile = cacheFileIn;
    }

    private void setImage(NativeImage nativeImageIn) {
        Minecraft.m_91087_().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.textureUploaded) {
                NativeImage nativeimage = null;
                if (this.cacheFile.isFile() && this.cacheFile.exists()) {
                    DoggyTalentsNext.LOGGER.debug("Loading dog texture from local cache ({})", (Object)this.cacheFile);
                    FileInputStream fileinputstream = null;
                    try {
                        fileinputstream = new FileInputStream(this.cacheFile);
                        nativeimage = this.loadTexture(fileinputstream);
                    }
                    catch (FileNotFoundException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileinputstream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)fileinputstream);
                    }
                    IOUtils.closeQuietly((InputStream)fileinputstream);
                }
                if (nativeimage != null) {
                    this.setImage(nativeimage);
                } else {
                    DoggyTalentsNext.LOGGER.warn("Was unable to set image ({})", (Object)this.cacheFile);
                }
            }
        });
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)inputStreamIn);
        }
        catch (IOException ioexception) {
            DoggyTalentsNext.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }
}

