/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.mixin;

import java.util.Iterator;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.ABBs;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;
import team.creative.creativecore.common.util.type.list.MarkList;

@Mixin(value={Shapes.class})
public class ShapesMixin {
    private static final String createIndexMerger = "Lnet/minecraft/world/phys/shapes/Shapes;createIndexMerger(ILit/unimi/dsi/fastutil/doubles/DoubleList;Lit/unimi/dsi/fastutil/doubles/DoubleList;ZZ)Lnet/minecraft/world/phys/shapes/IndexMerger;";

    @Inject(method={"joinUnoptimized(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/BooleanOp;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/shapes/Shapes;createIndexMerger(ILit/unimi/dsi/fastutil/doubles/DoubleList;Lit/unimi/dsi/fastutil/doubles/DoubleList;ZZ)Lnet/minecraft/world/phys/shapes/IndexMerger;")}, cancellable=true, require=1)
    private static void joinUnoptimized(VoxelShape shape1, VoxelShape shape2, BooleanOp operation, CallbackInfoReturnable<VoxelShape> info) {
        if (!(shape1 instanceof BoxesVoxelShape) && !(shape2 instanceof BoxesVoxelShape)) {
            return;
        }
        if (operation == BooleanOp.f_82689_) {
            ABBs bbs = new ABBs(shape1);
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                bbs.intersection(bb2.boxes);
            } else {
                bbs.intersectionVanilla(shape2.m_83299_());
            }
            info.setReturnValue((Object)BoxesVoxelShape.create(bbs.getBoxes()));
            return;
        }
        if (operation == BooleanOp.f_82688_) {
            ABBs intersection = new ABBs(shape1);
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                intersection.intersection(bb2.boxes);
            } else {
                intersection.intersectionVanilla(shape2.m_83299_());
            }
            ABBs bbs = new ABBs(shape1);
            bbs.addShape(shape2);
            bbs.cutOut(intersection);
            info.setReturnValue((Object)BoxesVoxelShape.create(bbs.getBoxes()));
            return;
        }
        if (operation == BooleanOp.f_82695_) {
            ABBs bbs = new ABBs(shape1);
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                bbs.addNonOverlapping(bb2.boxes);
            } else {
                bbs.addNonOverlappingVanilla(shape2.m_83299_());
            }
            info.setReturnValue((Object)BoxesVoxelShape.create(bbs.getBoxes()));
            return;
        }
        if (operation == BooleanOp.f_82693_) {
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                info.setReturnValue((Object)BoxesVoxelShape.create(bb1.boxes));
            } else {
                info.setReturnValue((Object)BoxesVoxelShape.createVanilla(shape1.m_83299_()));
            }
            return;
        }
        if (operation == BooleanOp.f_82691_) {
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                info.setReturnValue((Object)BoxesVoxelShape.create(bb2.boxes));
            } else {
                info.setReturnValue((Object)BoxesVoxelShape.createVanilla(shape2.m_83299_()));
            }
            return;
        }
        if (operation == BooleanOp.f_82685_) {
            ABBs bbs = new ABBs(shape1);
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                bbs.cutOut(bb2.boxes);
            } else {
                bbs.cutOutVanilla(shape2.m_83299_());
            }
            info.setReturnValue((Object)BoxesVoxelShape.create(bbs.getBoxes()));
            return;
        }
        if (operation == BooleanOp.f_82683_) {
            ABBs bbs = new ABBs(shape2);
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                bbs.cutOut(bb1.boxes);
            } else {
                bbs.cutOutVanilla(shape1.m_83299_());
            }
            info.setReturnValue((Object)BoxesVoxelShape.create(bbs.getBoxes()));
            return;
        }
        CreativeCore.LOGGER.warn("Apparentely there are more BooleanOp " + operation + "," + operation.getClass().getName() + ", which might result in horrible performance.");
    }

    private static boolean same(List<ABB> boxes1, List<ABB> boxes2) {
        MarkList<ABB> marked = new MarkList<ABB>(boxes1);
        block0: for (ABB second : boxes2) {
            Iterator iterator = marked.iterator();
            while (iterator.hasNext()) {
                ABB abb = (ABB)iterator.next();
                if (!second.equals(abb)) continue;
                iterator.mark();
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean sameVanilla(List<ABB> boxes1, List<AABB> boxes2) {
        MarkList<ABB> marked = new MarkList<ABB>(boxes1);
        block0: for (AABB second : boxes2) {
            Iterator iterator = marked.iterator();
            while (iterator.hasNext()) {
                ABB abb = (ABB)iterator.next();
                if (!abb.equals(second)) continue;
                iterator.mark();
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean intersects(Iterable<ABB> boxes1, Iterable<ABB> boxes2) {
        for (ABB first : boxes1) {
            for (ABB second : boxes2) {
                if (!first.intersects(second)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean intersectsVanilla(Iterable<ABB> boxes1, Iterable<AABB> boxes2) {
        for (ABB first : boxes1) {
            for (AABB second : boxes2) {
                if (!first.intersects(second)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"joinIsNotEmpty(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/BooleanOp;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/shapes/Shapes;createIndexMerger(ILit/unimi/dsi/fastutil/doubles/DoubleList;Lit/unimi/dsi/fastutil/doubles/DoubleList;ZZ)Lnet/minecraft/world/phys/shapes/IndexMerger;")}, cancellable=true, require=1)
    private static void joinIsNotEmpty(VoxelShape shape1, VoxelShape shape2, BooleanOp operation, CallbackInfoReturnable<Boolean> info) {
        if (!(shape1 instanceof BoxesVoxelShape) && !(shape2 instanceof BoxesVoxelShape)) {
            return;
        }
        if (operation == BooleanOp.f_82689_) {
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                if (shape2 instanceof BoxesVoxelShape) {
                    BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                    info.setReturnValue((Object)ShapesMixin.intersects(bb1.boxes, bb2.boxes));
                    return;
                }
            }
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                info.setReturnValue((Object)ShapesMixin.intersectsVanilla(bb1.boxes, shape2.m_83299_()));
                return;
            }
            if (!(shape2 instanceof BoxesVoxelShape)) return;
            BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
            info.setReturnValue((Object)ShapesMixin.intersectsVanilla(bb2.boxes, shape1.m_83299_()));
            return;
        }
        if (operation == BooleanOp.f_82688_) {
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                if (shape2 instanceof BoxesVoxelShape) {
                    BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                    info.setReturnValue((Object)(!ShapesMixin.intersects(bb1.boxes, bb2.boxes) ? 1 : 0));
                    return;
                }
            }
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                info.setReturnValue((Object)(!ShapesMixin.intersectsVanilla(bb1.boxes, shape2.m_83299_()) ? 1 : 0));
                return;
            }
            if (!(shape2 instanceof BoxesVoxelShape)) return;
            BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
            info.setReturnValue((Object)(!ShapesMixin.intersectsVanilla(bb2.boxes, shape1.m_83299_()) ? 1 : 0));
            return;
        }
        if (operation == BooleanOp.f_82695_) {
            info.setReturnValue((Object)(!shape1.m_83281_() || !shape2.m_83281_() ? 1 : 0));
            return;
        }
        if (operation == BooleanOp.f_82693_) {
            info.setReturnValue((Object)(!shape1.m_83281_() ? 1 : 0));
            return;
        }
        if (operation == BooleanOp.f_82691_) {
            info.setReturnValue((Object)(!shape2.m_83281_() ? 1 : 0));
            return;
        }
        if (operation == BooleanOp.f_82690_) {
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                if (shape2 instanceof BoxesVoxelShape) {
                    BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                    info.setReturnValue((Object)ShapesMixin.same(bb1.boxes, bb2.boxes));
                    return;
                }
            }
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                info.setReturnValue((Object)ShapesMixin.sameVanilla(bb1.boxes, shape2.m_83299_()));
                return;
            }
            if (!(shape2 instanceof BoxesVoxelShape)) return;
            BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
            info.setReturnValue((Object)ShapesMixin.sameVanilla(bb2.boxes, shape1.m_83299_()));
            return;
        }
        if (operation == BooleanOp.f_82687_) {
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                if (shape2 instanceof BoxesVoxelShape) {
                    BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                    info.setReturnValue((Object)(!ShapesMixin.same(bb1.boxes, bb2.boxes) ? 1 : 0));
                    return;
                }
            }
            if (shape1 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
                info.setReturnValue((Object)(!ShapesMixin.sameVanilla(bb1.boxes, shape2.m_83299_()) ? 1 : 0));
                return;
            }
            if (!(shape2 instanceof BoxesVoxelShape)) return;
            BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
            info.setReturnValue((Object)(!ShapesMixin.sameVanilla(bb2.boxes, shape1.m_83299_()) ? 1 : 0));
            return;
        }
        if (operation == BooleanOp.f_82685_) {
            ABBs bbs = new ABBs(shape1);
            if (shape2 instanceof BoxesVoxelShape) {
                BoxesVoxelShape bb2 = (BoxesVoxelShape)shape2;
                bbs.cutOut(bb2.boxes);
            } else {
                bbs.cutOutVanilla(shape2.m_83299_());
            }
            info.setReturnValue((Object)bbs.isEmpty());
            return;
        }
        if (operation != BooleanOp.f_82683_) {
            CreativeCore.LOGGER.warn("Apparentely there are more BooleanOp " + operation + "," + operation.getClass().getName() + ", which might result in horrible performance.");
            return;
        }
        ABBs bbs = new ABBs(shape2);
        if (shape1 instanceof BoxesVoxelShape) {
            BoxesVoxelShape bb1 = (BoxesVoxelShape)shape1;
            bbs.cutOut(bb1.boxes);
        } else {
            bbs.cutOutVanilla(shape1.m_83299_());
        }
        info.setReturnValue((Object)bbs.isEmpty());
    }
}

