/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.transformation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Rotation {
    X_CLOCKWISE(Axis.X, new RotationMatrix(1, 0, 0, 0, 0, -1, 0, 1, 0), true){

        @Override
        public Rotation opposite() {
            return X_COUNTER_CLOCKWISE;
        }
    }
    ,
    X_COUNTER_CLOCKWISE(Axis.X, new RotationMatrix(1, 0, 0, 0, 0, 1, 0, -1, 0), false){

        @Override
        public Rotation opposite() {
            return X_CLOCKWISE;
        }
    }
    ,
    Y_CLOCKWISE(Axis.Y, new RotationMatrix(0, 0, 1, 0, 1, 0, -1, 0, 0), true){

        @Override
        public Rotation opposite() {
            return Y_COUNTER_CLOCKWISE;
        }
    }
    ,
    Y_COUNTER_CLOCKWISE(Axis.Y, new RotationMatrix(0, 0, -1, 0, 1, 0, 1, 0, 0), false){

        @Override
        public Rotation opposite() {
            return Y_CLOCKWISE;
        }
    }
    ,
    Z_CLOCKWISE(Axis.Z, new RotationMatrix(0, -1, 0, 1, 0, 0, 0, 0, 1), true){

        @Override
        public Rotation opposite() {
            return Z_COUNTER_CLOCKWISE;
        }
    }
    ,
    Z_COUNTER_CLOCKWISE(Axis.Z, new RotationMatrix(0, 1, 0, -1, 0, 0, 0, 0, 1), false){

        @Override
        public Rotation opposite() {
            return Z_CLOCKWISE;
        }
    };

    private static final Facing[][] FACING_ROTATION;
    public final Axis axis;
    public final int direction;
    public final boolean clockwise;
    private final Vec3d vec;
    private final RotationMatrix rotationMatrix;

    public static Rotation getRotation(Axis axis, boolean clockwise) {
        switch (axis) {
            case X: {
                return clockwise ? X_CLOCKWISE : X_COUNTER_CLOCKWISE;
            }
            case Y: {
                return clockwise ? Y_CLOCKWISE : Y_COUNTER_CLOCKWISE;
            }
            case Z: {
                return clockwise ? Z_CLOCKWISE : Z_COUNTER_CLOCKWISE;
            }
        }
        return null;
    }

    public static Rotation getRotation(Vec3d vec) {
        if (vec.x > 0.0) {
            return X_CLOCKWISE;
        }
        if (vec.x < 0.0) {
            return X_COUNTER_CLOCKWISE;
        }
        if (vec.y > 0.0) {
            return Y_CLOCKWISE;
        }
        if (vec.y < 0.0) {
            return Y_COUNTER_CLOCKWISE;
        }
        if (vec.z > 0.0) {
            return Z_CLOCKWISE;
        }
        if (vec.z < 0.0) {
            return Z_COUNTER_CLOCKWISE;
        }
        return null;
    }

    public static Rotation getRotation(net.minecraft.world.level.block.Rotation rotationIn) {
        switch (rotationIn) {
            case CLOCKWISE_90: {
                return Y_CLOCKWISE;
            }
            case CLOCKWISE_180: {
                return Y_CLOCKWISE;
            }
            case COUNTERCLOCKWISE_90: {
                return Y_COUNTER_CLOCKWISE;
            }
        }
        return null;
    }

    public static int getRotationCount(net.minecraft.world.level.block.Rotation rotationIn) {
        if (rotationIn == net.minecraft.world.level.block.Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 1;
    }

    private Rotation(Axis axis, RotationMatrix matrix, boolean clockwise) {
        this.rotationMatrix = matrix;
        this.axis = axis;
        this.clockwise = clockwise;
        this.direction = clockwise ? 1 : -1;
        this.vec = new Vec3d();
        this.vec.set(axis, (double)this.direction);
    }

    public boolean getRotatedComponentPositive(Axis axis) {
        switch (axis) {
            case X: {
                if (this.rotationMatrix.m00 != 0) {
                    return this.rotationMatrix.m00 > 0;
                }
                if (this.rotationMatrix.m10 != 0) {
                    return this.rotationMatrix.m10 > 0;
                }
                return this.rotationMatrix.m20 > 0;
            }
            case Y: {
                if (this.rotationMatrix.m01 != 0) {
                    return this.rotationMatrix.m01 > 0;
                }
                if (this.rotationMatrix.m11 != 0) {
                    return this.rotationMatrix.m11 > 0;
                }
                return this.rotationMatrix.m21 > 0;
            }
            case Z: {
                if (this.rotationMatrix.m02 != 0) {
                    return this.rotationMatrix.m02 > 0;
                }
                if (this.rotationMatrix.m12 != 0) {
                    return this.rotationMatrix.m12 > 0;
                }
                return this.rotationMatrix.m22 > 0;
            }
        }
        return true;
    }

    public Axis getRotatedComponent(Axis axis) {
        switch (axis) {
            case X: {
                if (this.rotationMatrix.m00 != 0) {
                    return Axis.X;
                }
                if (this.rotationMatrix.m10 != 0) {
                    return Axis.Y;
                }
                return Axis.Z;
            }
            case Y: {
                if (this.rotationMatrix.m01 != 0) {
                    return Axis.X;
                }
                if (this.rotationMatrix.m11 != 0) {
                    return Axis.Y;
                }
                return Axis.Z;
            }
            case Z: {
                if (this.rotationMatrix.m02 != 0) {
                    return Axis.X;
                }
                if (this.rotationMatrix.m12 != 0) {
                    return Axis.Y;
                }
                return Axis.Z;
            }
        }
        return axis;
    }

    public boolean negativeX() {
        return this.rotationMatrix.m00 != 0 ? this.rotationMatrix.m00 < 0 : (this.rotationMatrix.m01 != 0 ? this.rotationMatrix.m01 < 0 : this.rotationMatrix.m02 < 0);
    }

    public <T> T getX(T x, T y, T z) {
        return this.rotationMatrix.m00 != 0 ? x : (this.rotationMatrix.m01 != 0 ? y : z);
    }

    public boolean negativeY() {
        return this.rotationMatrix.m10 != 0 ? this.rotationMatrix.m10 < 0 : (this.rotationMatrix.m11 != 0 ? this.rotationMatrix.m11 < 0 : this.rotationMatrix.m12 < 0);
    }

    public <T> T getY(T x, T y, T z) {
        return this.rotationMatrix.m10 != 0 ? x : (this.rotationMatrix.m11 != 0 ? y : z);
    }

    public boolean negativeZ() {
        return this.rotationMatrix.m20 != 0 ? this.rotationMatrix.m20 < 0 : (this.rotationMatrix.m21 != 0 ? this.rotationMatrix.m21 < 0 : this.rotationMatrix.m22 < 0);
    }

    public <T> T getZ(T x, T y, T z) {
        return this.rotationMatrix.m20 != 0 ? x : (this.rotationMatrix.m21 != 0 ? y : z);
    }

    public Vec3d getVec() {
        return new Vec3d(this.vec);
    }

    public RotationMatrix getMatrix() {
        return this.rotationMatrix;
    }

    public abstract Rotation opposite();

    public Facing rotate(Facing facing) {
        return FACING_ROTATION[facing.ordinal()][this.ordinal()];
    }

    public Axis rotate(Axis axis) {
        if (axis == this.axis) {
            return axis;
        }
        switch (axis) {
            case X: {
                if (this.axis == Axis.Y) {
                    return Axis.Z;
                }
                return Axis.Y;
            }
            case Y: {
                if (this.axis == Axis.Z) {
                    return Axis.X;
                }
                return Axis.Y;
            }
            case Z: {
                if (this.axis == Axis.X) {
                    return Axis.Y;
                }
                return Axis.X;
            }
        }
        return axis;
    }

    public Rotation mirror(Axis axis) {
        return this.axis == axis ? this.opposite() : this;
    }

    public Rotation rotate(Rotation by) {
        Vec3d vec = this.getVec();
        by.getMatrix().transform(vec);
        return Rotation.getRotation(vec);
    }

    public BlockPos transform(BlockPos vec) {
        return this.rotationMatrix.transform(vec);
    }

    public Vec3i transform(Vec3i vec) {
        return this.rotationMatrix.transform(vec);
    }

    public Vector3d transform(Vector3d vec) {
        return this.rotationMatrix.transform(vec);
    }

    public void transform(Vec3d vec) {
        this.rotationMatrix.transform(vec);
    }

    public void transform(Vec3f vec) {
        this.rotationMatrix.transform(vec);
    }

    static {
        FACING_ROTATION = new Facing[6][6];
        for (int i = 0; i < FACING_ROTATION.length; ++i) {
            Facing facing = Facing.get(i);
            block1: for (int j = 0; j < Rotation.values().length; ++j) {
                Rotation rotation = Rotation.values()[j];
                Vec3i rotatedNormal = new Vec3i(rotation.getMatrix().getX(facing.normal), rotation.getMatrix().getY(facing.normal), rotation.getMatrix().getZ(facing.normal));
                for (int k = 0; k < Facing.values().length; ++k) {
                    if (!Facing.get((int)k).normal.equals((Object)rotatedNormal)) continue;
                    Rotation.FACING_ROTATION[i][j] = Facing.get(k);
                    continue block1;
                }
            }
        }
    }

    public static class RotationMatrix {
        public int m00;
        public int m01;
        public int m02;
        public int m10;
        public int m11;
        public int m12;
        public int m20;
        public int m21;
        public int m22;

        public RotationMatrix(int m00, int m01, int m02, int m10, int m11, int m12, int m20, int m21, int m22) {
            this.m00 = m00;
            this.m01 = m01;
            this.m02 = m02;
            this.m10 = m10;
            this.m11 = m11;
            this.m12 = m12;
            this.m20 = m20;
            this.m21 = m21;
            this.m22 = m22;
        }

        public RotationMatrix(RotationMatrix m1, RotationMatrix m2) {
            this.m00 = m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20;
            this.m01 = m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21;
            this.m02 = m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22;
            this.m10 = m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20;
            this.m11 = m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21;
            this.m12 = m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22;
            this.m20 = m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20;
            this.m21 = m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21;
            this.m22 = m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22;
        }

        public int getX(int[] vec) {
            return this.getX(vec[0], vec[1], vec[2]);
        }

        public int getX(Vec3i vec) {
            return this.getX(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        public int getX(int x, int y, int z) {
            return x * this.m00 + y * this.m01 + z * this.m02;
        }

        public long getX(long x, long y, long z) {
            return x * (long)this.m00 + y * (long)this.m01 + z * (long)this.m02;
        }

        public int getY(int[] vec) {
            return this.getY(vec[0], vec[1], vec[2]);
        }

        public int getY(Vec3i vec) {
            return this.getY(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        public int getY(int x, int y, int z) {
            return x * this.m10 + y * this.m11 + z * this.m12;
        }

        public long getY(long x, long y, long z) {
            return x * (long)this.m10 + y * (long)this.m11 + z * (long)this.m12;
        }

        public int getZ(int[] vec) {
            return this.getZ(vec[0], vec[1], vec[2]);
        }

        public int getZ(Vec3i vec) {
            return this.getZ(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        public int getZ(int x, int y, int z) {
            return x * this.m20 + y * this.m21 + z * this.m22;
        }

        public long getZ(long x, long y, long z) {
            return x * (long)this.m20 + y * (long)this.m21 + z * (long)this.m22;
        }

        public BlockPos transform(BlockPos vec) {
            int x = vec.m_123341_() * this.m00 + vec.m_123342_() * this.m01 + vec.m_123343_() * this.m02;
            int y = vec.m_123341_() * this.m10 + vec.m_123342_() * this.m11 + vec.m_123343_() * this.m12;
            int z = vec.m_123341_() * this.m20 + vec.m_123342_() * this.m21 + vec.m_123343_() * this.m22;
            return new BlockPos(x, y, z);
        }

        public Vec3i transform(Vec3i vec) {
            int x = vec.m_123341_() * this.m00 + vec.m_123342_() * this.m01 + vec.m_123343_() * this.m02;
            int y = vec.m_123341_() * this.m10 + vec.m_123342_() * this.m11 + vec.m_123343_() * this.m12;
            int z = vec.m_123341_() * this.m20 + vec.m_123342_() * this.m21 + vec.m_123343_() * this.m22;
            return new Vec3i(x, y, z);
        }

        public Vector3d transform(Vector3d vec) {
            double x = vec.x * (double)this.m00 + vec.y * (double)this.m01 + vec.z * (double)this.m02;
            double y = vec.x * (double)this.m10 + vec.y * (double)this.m11 + vec.z * (double)this.m12;
            double z = vec.x * (double)this.m20 + vec.y * (double)this.m21 + vec.z * (double)this.m22;
            return new Vector3d(x, y, z);
        }

        public void transform(Vec3d triple) {
            double x = triple.x * (double)this.m00 + triple.y * (double)this.m01 + triple.z * (double)this.m02;
            double y = triple.x * (double)this.m10 + triple.y * (double)this.m11 + triple.z * (double)this.m12;
            double z = triple.x * (double)this.m20 + triple.y * (double)this.m21 + triple.z * (double)this.m22;
            triple.set(x, y, z);
        }

        public void transform(Vec3f triple) {
            float x = triple.x * (float)this.m00 + triple.y * (float)this.m01 + triple.z * (float)this.m02;
            float y = triple.x * (float)this.m10 + triple.y * (float)this.m11 + triple.z * (float)this.m12;
            float z = triple.x * (float)this.m20 + triple.y * (float)this.m21 + triple.z * (float)this.m22;
            triple.set(x, y, z);
        }

        public boolean equals(Object object) {
            if (object instanceof RotationMatrix) {
                RotationMatrix m1 = (RotationMatrix)object;
                return this.m00 == m1.m00 && this.m01 == m1.m01 && this.m02 == m1.m02 && this.m10 == m1.m10 && this.m11 == m1.m11 && this.m12 == m1.m12 && this.m20 == m1.m20 && this.m21 == m1.m21 && this.m22 == m1.m22;
            }
            return false;
        }

        public String toString() {
            return this.m00 + ", " + this.m01 + ", " + this.m02 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + "\n";
        }
    }
}

