/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.StackUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelector
extends GuiLabel {
    protected GuiStackSelectorExtension extension;
    public StackCollector collector;
    protected HashMapList<String, ItemStack> stacks;
    public boolean extensionLostFocus;
    public Player player;
    public boolean searchBar;
    protected ItemStack selected = ItemStack.f_41583_;

    public GuiStackSelector(String name, Player player, StackCollector collector, boolean searchBar) {
        super(name);
        this.searchBar = searchBar;
        this.player = player;
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(String name, Player player, StackCollector collector) {
        this(name, player, collector, true);
    }

    public GuiStackSelector setWidth(int width) {
        this.setDim(width, 14);
        return this;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.extension == null) {
            this.openBox(rect);
        } else {
            this.closeBox();
        }
        GuiStackSelector.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    public boolean selectFirst() {
        ItemStack first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first);
            return true;
        }
        return false;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public void updateCollectedStacks() {
        this.stacks = this.collector.collect(this.player);
    }

    public boolean setSelectedForce(ItemStack stack) {
        this.setTitle(new TextBuilder().stack(stack).add(stack.m_41786_()).build());
        this.selected = stack;
        this.raiseEvent(new GuiControlChangedEvent(this));
        return true;
    }

    public boolean setSelected(ItemStack stack) {
        if (this.stacks.contains(stack)) {
            this.setTitle(new TextBuilder().stack(stack).add(stack.m_41786_()).build());
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    public HashMapList<String, ItemStack> getStacks() {
        return this.stacks;
    }

    public ItemStack getSelected() {
        return this.selected;
    }

    public void openBox(Rect rect) {
        this.extension = this.createBox();
        GuiChildControl child = this.getLayer().addHover(this.extension);
        rect = this.toLayerRect(new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight()));
        this.extension.init();
        child.setX((int)rect.minX);
        child.setY((int)rect.maxY);
        child.setWidth((int)rect.getWidth(), (int)this.getLayer().rect.getWidth() - this.getContentOffset() * 2);
        child.flowX();
        int height = (int)this.getLayer().rect.getHeight() - this.getContentOffset() * 2;
        child.setHeight(child.getPreferredHeight(height), height);
        child.flowY();
        Rect absolute = this.toScreenRect(child.rect.copy());
        Rect screen = Rect.getScreenRect();
        if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
            child.setY(child.getY() - ((int)rect.getHeight() + child.getHeight()));
        }
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }

    protected GuiStackSelectorExtension createBox() {
        return new GuiStackSelectorExtension(this.name + "extension", this.getPlayer(), this);
    }

    public boolean select(String line) {
        return false;
    }

    @Override
    public void looseFocus() {
        if (this.extensionLostFocus && this.extension != null) {
            this.closeBox();
        }
    }

    public static boolean contains(String search, ItemStack stack) {
        if (search.equals("")) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (Component line : stack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.m_41611_().getString();
        }
        catch (Exception e) {
            itemName = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        }
        return itemName;
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, ItemStack> collect(Player var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return Block.m_49814_((Item)stack.m_41720_()) != null && !(Block.m_49814_((Item)stack.m_41720_()) instanceof AirBlock);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(ItemStack stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(ItemStack var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = super.collect(player);
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (Item item : BuiltInRegistries.f_257033_) {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (!this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("collector.all", (ItemStack)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = new HashMapList<String, ItemStack>();
            if (player != null) {
                ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : player.f_36095_.m_38927_()) {
                    if (!stack.m_41619_() && this.selector.allow(stack)) {
                        tempStacks.add(stack.m_41777_());
                        continue;
                    }
                    LazyOptional<IItemHandler> result = StackUtils.getStackInventory(stack);
                    if (!result.isPresent()) continue;
                    this.collect((IItemHandler)result.orElseThrow(RuntimeException::new), tempStacks);
                }
                stacks.add("collector.inventory", (ItemStack)tempStacks);
            }
            return stacks;
        }

        protected void collect(IItemHandler inventory, List<ItemStack> stacks) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (!stack.m_41619_() && this.selector.allow(stack)) {
                    stacks.add(stack.m_41777_());
                    continue;
                }
                LazyOptional<IItemHandler> result = StackUtils.getStackInventory(stack);
                if (!result.isPresent()) continue;
                this.collect((IItemHandler)result.orElseThrow(RuntimeException::new), stacks);
            }
        }
    }
}

