/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.SoundTypes;
import com.sonicether.soundphysics.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.SoundType;

public class OcclusionConfig
extends CommentedPropertyConfig {
    private Map<SoundType, Double> occlusion;

    public OcclusionConfig(Path path) {
        super(path);
        this.save();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.occlusion = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            double value;
            String key = entry.getKey();
            try {
                value = Double.parseDouble(entry.getValue());
            }
            catch (NumberFormatException e) {
                SoundPhysics.LOGGER.warn("Failed to parse occlusion factor of {}", (Object)key);
                continue;
            }
            SoundType soundType = SoundTypes.getSoundType(key);
            if (soundType == null) {
                SoundPhysics.LOGGER.warn("Sound type {} not found", (Object)key);
                continue;
            }
            this.occlusion.put(soundType, value);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        for (Map.Entry<SoundType, Double> entry : this.occlusion.entrySet()) {
            this.properties.set(SoundTypes.getName(entry.getKey()), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<SoundType, Double> getOcclusionFactors() {
        return this.occlusion;
    }

    public double getOcclusionFactor(SoundType soundType) {
        return this.occlusion.getOrDefault(soundType, SoundPhysicsMod.CONFIG.defaultBlockOcclusionFactor.get());
    }

    public OcclusionConfig setOcclusionFactor(SoundType soundType, double value) {
        this.occlusion.put(soundType, value);
        return this;
    }

    public Map<SoundType, Double> createDefaultMap() {
        HashMap<SoundType, Double> map = new HashMap<SoundType, Double>();
        for (SoundType type : SoundTypes.getTranslationMap().keySet()) {
            map.put(type, SoundPhysicsMod.CONFIG.defaultBlockOcclusionFactor.get());
        }
        map.put(SoundType.f_56745_, 1.5);
        map.put(SoundType.f_154669_, 0.75);
        map.put(SoundType.f_56751_, 0.5);
        map.put(SoundType.f_56744_, 0.1);
        map.put(SoundType.f_56747_, 0.1);
        map.put(SoundType.f_154681_, 0.1);
        map.put(SoundType.f_56754_, 0.1);
        map.put(SoundType.f_56755_, 0.1);
        map.put(SoundType.f_56752_, 0.1);
        map.put(SoundType.f_154668_, 0.1);
        map.put(SoundType.f_56714_, 0.0);
        map.put(SoundType.f_56715_, 0.0);
        map.put(SoundType.f_56760_, 0.0);
        map.put(SoundType.f_56757_, 0.0);
        map.put(SoundType.f_154665_, 0.0);
        map.put(SoundType.f_154671_, 0.0);
        map.put(SoundType.f_56712_, 0.0);
        map.put(SoundType.f_154662_, 0.0);
        map.put(SoundType.f_56756_, 0.0);
        map.put(SoundType.f_154676_, 0.0);
        map.put(SoundType.f_56758_, 0.0);
        map.put(SoundType.f_56711_, 0.0);
        map.put(SoundType.f_56741_, 0.0);
        map.put(SoundType.f_154658_, 0.0);
        map.put(SoundType.f_154657_, 0.0);
        map.put(SoundType.f_154656_, 0.0);
        map.put(SoundType.f_56748_, 0.0);
        map.put(SoundType.f_56728_, 0.0);
        return map;
    }
}

