/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.module.IDisableable;

public class CreativeTabManager {
    private static final Object MUTEX = new Object();
    private static final Map<ResourceKey<CreativeModeTab>, CreativeTabAdditions> additions = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabAdditions>();
    private static final Multimap<ItemLike, ResourceKey<CreativeModeTab>> mappedItems = HashMultimap.create();
    private static boolean daisyChainMode = false;
    private static ItemSet daisyChainedSet = null;

    public static void daisyChain() {
        daisyChainMode = true;
        daisyChainedSet = null;
    }

    public static void endDaisyChain() {
        daisyChainMode = false;
        daisyChainedSet = null;
    }

    public static void addToCreativeTab(ResourceKey<CreativeModeTab> tab, ItemLike item) {
        if (daisyChainMode) {
            if (daisyChainedSet == null) {
                throw new IllegalArgumentException("Must start daisy chain with addToCreativeTabNextTo");
            }
            CreativeTabManager.addToDaisyChain(item);
        } else {
            CreativeTabManager.getForTab(tab).appendToEnd.add(item);
        }
        mappedItems.put((Object)item, tab);
    }

    public static void addToCreativeTabNextTo(ResourceKey<CreativeModeTab> tab, ItemLike item, ItemLike target, boolean behind) {
        tab = CreativeTabManager.guessTab(target, tab);
        CreativeTabAdditions additions = CreativeTabManager.getForTab(tab);
        Map<ItemSet, ItemLike> map = behind ? additions.appendBehind : additions.appendInFront;
        ItemSet toAdd = null;
        if (daisyChainMode) {
            boolean newSet = daisyChainedSet == null;
            ItemSet set = CreativeTabManager.addToDaisyChain(item);
            if (newSet) {
                toAdd = set;
            }
        } else {
            toAdd = new ItemSet(item);
        }
        if (toAdd != null) {
            map.put(toAdd, target);
        }
        mappedItems.put((Object)item, tab);
    }

    private static ItemSet addToDaisyChain(ItemLike item) {
        if (daisyChainMode && daisyChainedSet != null) {
            CreativeTabManager.daisyChainedSet.items.add(item);
            return daisyChainedSet;
        }
        ItemSet set = new ItemSet(item);
        if (daisyChainMode) {
            daisyChainedSet = set;
        }
        return set;
    }

    private static ResourceKey<CreativeModeTab> guessTab(ItemLike parent, ResourceKey<CreativeModeTab> tab) {
        if (parent != null && mappedItems.containsKey((Object)parent)) {
            tab = (ResourceKey)mappedItems.get((Object)parent).iterator().next();
        }
        return tab;
    }

    private static CreativeTabAdditions getForTab(ResourceKey<CreativeModeTab> tab) {
        return additions.computeIfAbsent(tab, tabRk -> new CreativeTabAdditions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        Object object = MUTEX;
        synchronized (object) {
            ResourceKey tabKey = event.getTabKey();
            if (additions.containsKey(tabKey)) {
                CreativeTabAdditions add = additions.get(tabKey);
                for (ItemLike item : add.appendToEnd) {
                    CreativeTabManager.acceptItem(event, item);
                }
                MutableHashedLinkedMap entries = event.getEntries();
                LinkedHashMap<ItemSet, ItemLike> front = new LinkedHashMap<ItemSet, ItemLike>(add.appendInFront);
                LinkedHashMap<ItemSet, ItemLike> behind = new LinkedHashMap<ItemSet, ItemLike>(add.appendBehind);
                int failsafe = 99999;
                int printThreshold = 99899;
                int misses = 0;
                boolean failsafing = false;
                do {
                    boolean missed = false;
                    if (!front.isEmpty()) {
                        missed = CreativeTabManager.appendNextTo((ResourceKey<CreativeModeTab>)tabKey, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, front, false, failsafing);
                    }
                    if (!behind.isEmpty()) {
                        missed |= CreativeTabManager.appendNextTo((ResourceKey<CreativeModeTab>)tabKey, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, behind, true, failsafing);
                    }
                    if (missed) {
                        ++misses;
                    }
                    if (misses > 99999) {
                        new RuntimeException("Creative tab placement misses exceeded failsafe, aborting logic").printStackTrace();
                        return;
                    }
                    if (misses <= 99899) continue;
                    failsafing = true;
                } while (!front.isEmpty() || !behind.isEmpty());
                return;
            }
        }
    }

    private static boolean isItemEnabled(ItemLike item) {
        if (item instanceof IDisableable) {
            IDisableable id = (IDisableable)item;
            return id.isEnabled();
        }
        return true;
    }

    private static void acceptItem(BuildCreativeModeTabContentsEvent event, ItemLike item) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            event.m_246601_(au.appendItemsToCreativeTab());
        } else {
            event.m_246326_(item);
        }
    }

    private static void addToEntries(ItemStack target, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike item, boolean behind) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        List<ItemStack> stacksToAdd = Arrays.asList(new ItemStack(item));
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            stacksToAdd = au.appendItemsToCreativeTab();
        }
        if (!behind) {
            Collections.reverse(stacksToAdd);
        }
        for (ItemStack addStack : stacksToAdd) {
            if (behind) {
                entries.putBefore((Object)target, (Object)addStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            entries.putAfter((Object)target, (Object)addStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static boolean appendNextTo(ResourceKey<CreativeModeTab> tabKey, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, Map<ItemSet, ItemLike> map, boolean behind, boolean log) {
        Set<ItemSet> coll = map.keySet();
        if (coll.isEmpty()) {
            throw new RuntimeException("Tab collection is empty, this should never happen.");
        }
        ItemSet firstSet = (ItemSet)coll.iterator().next();
        ItemLike firstSetItem = firstSet.items.get(0);
        ItemLike target = map.get(firstSet);
        if (log) {
            Zeta.GLOBAL_LOG.warn("Creative tab loop found when adding {} next to {}", (Object)firstSetItem, (Object)target);
        }
        map.remove(firstSet);
        if (!CreativeTabManager.isItemEnabled(firstSetItem) || target == null) {
            return false;
        }
        for (Map.Entry entry : entries) {
            ItemStack stack = (ItemStack)entry.getKey();
            Item item = stack.m_41720_();
            if (item != target.m_5456_()) continue;
            for (int i = 0; i < firstSet.items.size(); ++i) {
                int j = i;
                if (!behind) {
                    j = firstSet.items.size() - 1 - i;
                }
                CreativeTabManager.addToEntries(stack, entries, firstSet.items.get(j), behind);
            }
            return false;
        }
        map.put(firstSet, target);
        return true;
    }

    private static class ItemSet {
        List<ItemLike> items = new ArrayList<ItemLike>();

        public ItemSet(ItemLike item) {
            this.items.add(item);
        }

        public boolean isFresh() {
            return this.items.size() == 1;
        }
    }

    private static class CreativeTabAdditions {
        private List<ItemLike> appendToEnd = new ArrayList<ItemLike>();
        private Map<ItemSet, ItemLike> appendInFront = new LinkedHashMap<ItemSet, ItemLike>();
        private Map<ItemSet, ItemLike> appendBehind = new LinkedHashMap<ItemSet, ItemLike>();

        private CreativeTabAdditions() {
        }
    }

    public static interface AppendsUniquely
    extends ItemLike {
        public List<ItemStack> appendItemsToCreativeTab();
    }
}

