/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import dan200.computercraft.shared.util.RedstoneUtil;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RedstoneIntegratorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RedstoneIntegratorEntity
extends PeripheralBlockEntity<RedstoneIntegratorPeripheral> {
    public int[] power = new int[Direction.values().length];

    public RedstoneIntegratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.REDSTONE_INTEGRATOR.get(), pos, state);
    }

    @Override
    @NotNull
    protected RedstoneIntegratorPeripheral createPeripheral() {
        return new RedstoneIntegratorPeripheral(this);
    }

    public int getRedstoneInput(Direction direction) {
        Objects.requireNonNull(this.f_58857_);
        BlockPos neighbourPos = this.m_58899_().m_121945_(direction);
        int power = this.f_58857_.m_277185_(neighbourPos, direction);
        if (power >= 15) {
            return power;
        }
        BlockState neighbourState = this.f_58857_.m_8055_(neighbourPos);
        return neighbourState.m_60734_() == Blocks.f_50088_ ? Math.max(power, (Integer)neighbourState.m_61143_((Property)RedStoneWireBlock.f_55500_)) : power;
    }

    private void setRedstoneOutput(Direction direction, int power) {
        int old = this.power[direction.m_122411_()];
        this.power[direction.m_122411_()] = power;
        if (old != power) {
            if (this.f_58857_ != null) {
                RedstoneUtil.propagateRedstoneOutput((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Direction)direction);
            }
            this.m_6596_();
        }
    }

    public void setOutput(Direction direction, int power) {
        ServerWorker.add(() -> this.setRedstoneOutput(direction, power));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        for (Direction direction : Direction.values()) {
            this.setRedstoneOutput(direction, compound.m_128451_(direction.name() + "Power"));
        }
        super.m_142466_(compound);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        int i = 0;
        for (Direction direction : Direction.values()) {
            compound.m_128405_(direction.name() + "Power", this.power[i]);
            ++i;
        }
    }
}

