/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SoftFluidRegistry {
    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.m_135788_((ResourceLocation)Moonlight.res("soft_fluids"));
    protected static final Map<Fluid, Holder<SoftFluid>> FLUID_MAP = new IdentityHashMap<Fluid, Holder<SoftFluid>>();
    protected static final Map<Item, Holder<SoftFluid>> ITEM_MAP = new IdentityHashMap<Item, Holder<SoftFluid>>();

    public static Holder<SoftFluid> getEmpty() {
        return BuiltInSoftFluids.EMPTY.getHolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    public static Registry<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static Registry<SoftFluid> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(KEY);
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.hackyGetRegistry().m_123024_().toList();
    }

    public static Collection<Holder.Reference<SoftFluid>> getHolders() {
        return SoftFluidRegistry.hackyGetRegistry().m_203611_().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.hackyGetRegistry().m_6579_();
    }

    public static Holder<SoftFluid> getHolder(ResourceLocation id) {
        Optional<Holder.Reference<SoftFluid>> opt = SoftFluidRegistry.getOptionalHolder(id);
        if (opt.isPresent()) {
            return (Holder)opt.get();
        }
        return SoftFluidRegistry.getEmpty();
    }

    public static Optional<Holder.Reference<SoftFluid>> getOptionalHolder(ResourceLocation id) {
        id = SoftFluidRegistry.backwardsCompat(id);
        return SoftFluidRegistry.hackyGetRegistry().m_203636_(ResourceKey.m_135785_(KEY, (ResourceLocation)id));
    }

    @NotNull
    private static ResourceLocation backwardsCompat(ResourceLocation id) {
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.m_135815_());
        }
        return id;
    }

    private static void populateSlaveMaps() {
        Map<Item, Holder<SoftFluid>> itemMap = ITEM_MAP;
        itemMap.clear();
        Map<Fluid, Holder<SoftFluid>> fluidsMap = FLUID_MAP;
        fluidsMap.clear();
        for (Holder.Reference<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.m_203334_();
            if (!PlatHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((Fluid)f, (Holder<SoftFluid>)h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.f_42589_ || s != BuiltInSoftFluids.WATER.get()) {
                    itemMap.put((Item)i, (Holder<SoftFluid>)h);
                }
            });
        }
    }

    @ApiStatus.Internal
    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    @ApiStatus.Internal
    public static void doPostInitServer() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.registerExistingVanillaFluids(FLUID_MAP, ITEM_MAP);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidRegistryImpl.registerExistingVanillaFluids(fluidMap, (Map<Item, Holder<SoftFluid>>)var1_1);
    }
}

