/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.BaseAttachment;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class RearAttachment
extends BaseAttachment<RearAttachmentType<?>> {
    private float lastYaw;
    private float yaw;
    private float trackedYaw;
    private int yawLerpProgress;

    protected RearAttachment(RearAttachmentType<?> type, AutomobileEntity entity) {
        super(type, entity);
    }

    public final Vec3 yawVec() {
        return new Vec3(0.0, 0.0, 1.0).m_82524_((float)Math.toRadians(180.0f - this.yaw()));
    }

    public final Vec3 scaledYawVec() {
        return this.yawVec().m_82490_((double)((RearAttachmentType)this.type).model().pivotDistPx() * 0.0625);
    }

    public final Vec3 origin() {
        return this.automobile.getTailPos();
    }

    @Override
    public final Vec3 pos() {
        return this.origin().m_82549_(this.scaledYawVec());
    }

    public float yaw() {
        return this.yaw;
    }

    public float yaw(float delta) {
        return Mth.m_14189_((float)delta, (float)this.lastYaw, (float)this.yaw());
    }

    public void setYaw(float yaw) {
        float diff = Mth.m_14177_((float)(yaw - this.automobile.m_146908_()));
        if (diff < -90.0f && diff > -180.0f) {
            yaw = this.automobile.m_146908_() - 90.0f;
        } else if (diff > 90.0f && diff < 180.0f) {
            yaw = this.automobile.m_146908_() + 90.0f;
        }
        this.yaw = yaw;
    }

    protected final void updateTrackedYaw(float yaw) {
        this.automobile.setTrackedRearAttachmentYaw(yaw);
    }

    public void onTrackedYawUpdated(float yaw) {
        this.trackedYaw = yaw;
        this.yawLerpProgress = this.automobile.m_6095_().m_20682_() + 1;
    }

    @Override
    protected final void updateTrackedAnimation(float animation) {
        this.automobile.setTrackedRearAttachmentAnimation(animation);
    }

    public final void pull(Vec3 movement) {
        Vec3 vec = this.scaledYawVec().m_82549_(movement);
        this.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(vec.f_82479_, vec.f_82481_)));
    }

    @Override
    public void tick() {
        this.lastYaw = this.yaw();
        this.rotationTrackingTick();
    }

    private void rotationTrackingTick() {
        if (!this.world().m_5776_()) {
            this.yawLerpProgress = 0;
            this.updateTrackedYaw(this.yaw());
        } else if (this.yawLerpProgress > 0) {
            this.setYaw(this.yaw() + Mth.m_14177_((float)(this.trackedYaw - this.yaw())) / (float)this.yawLerpProgress);
            --this.yawLerpProgress;
        }
    }

    public boolean isRideable() {
        return false;
    }

    public double getPassengerHeightOffset() {
        return 0.5;
    }

    public boolean hasMenu() {
        return false;
    }

    @Nullable
    public MenuProvider createMenu(ContainerLevelAccess ctx) {
        return null;
    }

    @Override
    public void writeNbt(CompoundTag nbt) {
        nbt.m_128350_("yaw", this.yaw());
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.setYaw(nbt.m_128457_("yaw"));
    }

    public static RearAttachmentType<?> fromNbt(CompoundTag nbt) {
        return RearAttachmentType.REGISTRY.get(ResourceLocation.m_135820_((String)nbt.m_128461_("type")));
    }
}

