/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf.client;

import com.anar4732.opf.OPFBlock;
import com.anar4732.opf.OPFEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OPFRenderer
implements BlockEntityRenderer<OPFEntity> {
    private final BlockEntityRendererProvider.Context context;

    public OPFRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(OPFEntity frame, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        frame.tickTexture();
        Direction direction = (Direction)frame.m_58900_().m_61143_((Property)OPFBlock.FACING);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        OPFRenderer.applyDirection(matrixStack, direction);
        if (frame.onFloor) {
            matrixStack.m_85837_(-0.5, -0.49, 0.5);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (((Boolean)frame.m_58900_().m_61143_((Property)OPFBlock.ATTACHED)).booleanValue()) {
            matrixStack.m_85837_(-0.5, 0.0, -0.93);
        } else {
            matrixStack.m_85837_(-0.5, 0.0, 0.01);
        }
        VertexConsumer builder = null;
        if (frame.shouldLoadTexture()) {
            frame.loadTexture();
        }
        builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)frame.textureLocation));
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.5f, frame.flippedX ? 0.0f : 1.0f, !frame.flippedY ? 1.0f : 0.0f, combinedLightIn);
        this.add(builder, matrixStack, frame.sizeX, 0.0f, 0.5f, frame.flippedX ? 1.0f : 0.0f, !frame.flippedY ? 1.0f : 0.0f, combinedLightIn);
        this.add(builder, matrixStack, frame.sizeX, frame.sizeY, 0.5f, frame.flippedX ? 1.0f : 0.0f, !frame.flippedY ? 0.0f : 1.0f, combinedLightIn);
        this.add(builder, matrixStack, 0.0f, frame.sizeY, 0.5f, frame.flippedX ? 0.0f : 1.0f, !frame.flippedY ? 0.0f : 1.0f, combinedLightIn);
        if (!frame.textureWorker.loaded) {
            Font fontRenderer = this.context.m_173586_();
            matrixStack.m_85837_((double)0.1f, (double)(0.5f * (float)(Math.max(frame.sizeY, 2) / 2)), (double)0.55f);
            matrixStack.m_85841_(0.01f * (float)frame.sizeX, 0.01f * (float)frame.sizeY, 0.002f);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            if (!frame.textureWorker.error) {
                fontRenderer.m_271703_("Still Loading ...", 0.0f, 0.0f, DyeColor.LIME.m_41071_(), false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            } else {
                fontRenderer.m_271703_("Error", 0.0f, 0.0f, DyeColor.RED.m_41071_(), false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            }
        }
        matrixStack.m_85849_();
    }

    private void add(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int combinedLight) {
        renderer.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void applyDirection(PoseStack matrixStack, Direction direction) {
        int rotation = switch (direction) {
            case Direction.EAST -> 0;
            case Direction.NORTH -> 90;
            case Direction.SOUTH -> 270;
            case Direction.WEST -> 180;
            default -> 0;
        };
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(rotation - 90)));
    }

    public boolean shouldRenderOffScreen(OPFEntity te) {
        return te.sizeX > 12 || te.sizeY > 12;
    }

    public int m_142163_() {
        return 128;
    }
}

