/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class Utils {
    public static VoxelShape toVoxelShape(AlignedBox box) {
        return Shapes.m_83048_((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ);
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction) {
        return Utils.rotateCube(cube, direction, new Vector3d(0.5, 0.5, 0.5));
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction, Vector3d center) {
        AlignedBox rotateCube = new AlignedBox(cube);
        Utils.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public static Vector3d applyVectorRotation(Vector3d vector, Direction direction) {
        double tempX = vector.x;
        double tempY = vector.y;
        double tempZ = vector.z;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (direction) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
            }
        }
        return new Vector3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(AlignedBox cube, Direction direction, Vector3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.x);
            minY = (float)((double)minY - center.y);
            minZ = (float)((double)minZ - center.z);
            maxX = (float)((double)maxX - center.x);
            maxY = (float)((double)maxY - center.y);
            maxZ = (float)((double)maxZ - center.z);
        }
        Vector3d min = Utils.applyVectorRotation(new Vector3d((double)minX, (double)minY, (double)minZ), direction);
        Vector3d max = Utils.applyVectorRotation(new Vector3d((double)maxX, (double)maxY, (double)maxZ), direction);
        if (center != null) {
            min.add((Vector3dc)new Vector3d(center.x, center.y, center.z));
            max.add((Vector3dc)new Vector3d(center.x, center.y, center.z));
        }
        if (min.x < max.x) {
            cube.minX = (float)min.x;
            cube.maxX = (float)max.x;
        } else {
            cube.minX = (float)max.x;
            cube.maxX = (float)min.x;
        }
        if (min.y < max.y) {
            cube.minY = (float)min.y;
            cube.maxY = (float)max.y;
        } else {
            cube.minY = (float)max.y;
            cube.maxY = (float)min.y;
        }
        if (min.z < max.z) {
            cube.minZ = (float)min.z;
            cube.maxZ = (float)max.z;
        } else {
            cube.minZ = (float)max.z;
            cube.maxZ = (float)min.z;
        }
    }
}

