/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import ht.treechop.TreeChop;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.registry.ForgeModBlocks;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChoppedLogBakedModel
extends ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<Direction, BlockState>> STRIPPED_NEIGHBORS = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    public static ModelProperty<Integer> RADIUS = new ModelProperty();
    public static ModelProperty<ChoppedLogShape> CHOPPED_LOG_SHAPE = new ModelProperty();

    public static void overrideBlockStateModels(ModelEvent.ModifyBakingResult event) {
        for (BlockState blockState : ((Block)ForgeModBlocks.CHOPPED_LOG.get()).m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            BakedModel existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null) {
                TreeChop.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ForgeChoppedLogBakedModel) {
                TreeChop.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            ForgeChoppedLogBakedModel customModel = new ForgeChoppedLogBakedModel();
            ForgeChoppedLogBakedModel.setDefaultSprite(((BakedModel)event.getModels().get(variantMRL)).m_6160_());
            event.getModels().put(variantMRL, customModel);
        }
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RENDER_TYPE});
    }

    @Nonnull
    public static ModelData getModelData(ChoppedLogBlock.MyEntity entity) {
        BlockState strippedState = ChopUtil.getStrippedState((BlockAndTintGetter)entity.m_58904_(), entity.m_58899_(), entity.getOriginalState());
        ModelData.Builder builder = ModelData.builder();
        builder.with(STRIPPED_NEIGHBORS, ForgeChoppedLogBakedModel.getStrippedNeighbors((BlockAndTintGetter)entity.m_58904_(), entity.m_58899_(), entity));
        builder.with(STRIPPED_BLOCK_STATE, (Object)strippedState);
        builder.with(RADIUS, (Object)entity.getRadius());
        builder.with(CHOPPED_LOG_SHAPE, (Object)entity.getShape());
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null) {
            BlockState strippedState = this.or((BlockState)extraData.get(STRIPPED_BLOCK_STATE), Blocks.f_50010_.m_49966_());
            Map<Direction, BlockState> strippedNeighbors = this.or((Map)extraData.get(STRIPPED_NEIGHBORS), Collections.emptyMap());
            ChoppedLogShape shape = this.or((ChoppedLogShape)((Object)extraData.get(CHOPPED_LOG_SHAPE)), ChoppedLogShape.PILLAR_Y);
            int radius = this.or((Integer)extraData.get(RADIUS), 8);
            return this.getQuads(strippedState, shape, radius, rand, strippedNeighbors).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockState strippedState = this.or((BlockState)data.get(STRIPPED_BLOCK_STATE), Blocks.f_50010_.m_49966_());
        return ForgeChoppedLogBakedModel.getBlockModel(strippedState).m_6160_();
    }

    private <T> T or(T value, T fallback) {
        return value != null ? value : fallback;
    }
}

