/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.shapes;

import com.abdelaziz.canary.common.shapes.VoxelShapeAlignedCuboid;
import com.abdelaziz.canary.common.shapes.lists.OffsetFractionalDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeAlignedCuboidOffset
extends VoxelShapeAlignedCuboid {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public VoxelShapeAlignedCuboidOffset(VoxelShapeAlignedCuboid originalShape, DiscreteVoxelShape voxels, double xOffset, double yOffset, double zOffset) {
        super(voxels, originalShape.xSegments, originalShape.ySegments, originalShape.zSegments, originalShape.minX + xOffset, originalShape.minY + yOffset, originalShape.minZ + zOffset, originalShape.maxX + xOffset, originalShape.maxY + yOffset, originalShape.maxZ + zOffset);
        if (originalShape instanceof VoxelShapeAlignedCuboidOffset) {
            this.xOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).xOffset + xOffset;
            this.yOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).yOffset + yOffset;
            this.zOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).zOffset + zOffset;
        } else {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double shapeOffset, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            int segment = Mth.m_14165_((double)((bMax - 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
            double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
            if (wallPos < bMax - 1.0E-7) {
                wallPos = (double)(++segment) / (double)segmentsPerUnit + shapeOffset;
            }
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        int segment = Mth.m_14107_((double)((bMin + 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
        double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
        if (wallPos > bMin + 1.0E-7) {
            wallPos = (double)(--segment) / (double)segmentsPerUnit + shapeOffset;
        }
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public VoxelShape m_83216_(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.f_83211_, x, y, z);
    }

    @Override
    public double m_83245_(AxisCycle cycleDirection, AABB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisCycle dir, AABB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minX, this.maxX, this.xSegments, this.xOffset, box.f_82288_, box.f_82291_, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minZ, this.maxZ, this.zSegments, this.zOffset, box.f_82290_, box.f_82293_, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minY, this.maxY, this.ySegments, this.yOffset, box.f_82289_, box.f_82292_, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DoubleList m_7700_(Direction.Axis axis) {
        return new OffsetFractionalDoubleList(axis.m_7863_(this.xSegments, this.ySegments, this.zSegments), axis.m_6150_(this.xOffset, this.yOffset, this.zOffset));
    }

    @Override
    protected double m_83256_(Direction.Axis axis, int index) {
        return axis.m_6150_(this.xOffset, this.yOffset, this.zOffset) + (double)index / (double)axis.m_7863_(this.xSegments, this.ySegments, this.zSegments);
    }

    @Override
    protected int m_6595_(Direction.Axis axis, double coord) {
        int numSegments = axis.m_7863_(this.xSegments, this.ySegments, this.zSegments);
        return Mth.m_14045_((int)Mth.m_14107_((double)((coord -= axis.m_6150_(this.xOffset, this.yOffset, this.zOffset)) * (double)numSegments)), (int)-1, (int)numSegments);
    }
}

