/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<EntityHitResult>
implements EntityAccessor {
    private final java.util.function.Supplier<Entity> entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected, builder.showDetails);
        this.entity = builder.entity;
    }

    public static void handleRequest(FriendlyByteBuf buf, ServerPlayer player, Consumer<Runnable> executor, Consumer<CompoundTag> responseSender) {
        EntityAccessor accessor;
        try {
            accessor = EntityAccessorImpl.fromNetwork(buf, player);
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, null, null);
            return;
        }
        executor.accept(() -> {
            Entity entity = accessor.getEntity();
            if (entity == null || player.m_20280_(entity) > (double)Jade.MAX_DISTANCE_SQR) {
                return;
            }
            List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.INSTANCE.getEntityNBTProviders(entity);
            if (providers.isEmpty()) {
                return;
            }
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<EntityAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Throwable e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.m_128405_("WailaEntityID", entity.m_19879_());
            responseSender.accept(tag);
        });
    }

    public static EntityAccessor fromNetwork(FriendlyByteBuf buf, ServerPlayer player) {
        Builder builder = new Builder();
        builder.level(player.m_9236_());
        builder.player((Player)player);
        builder.showDetails(buf.readBoolean());
        int id = buf.m_130242_();
        float hitX = buf.readFloat();
        float hitY = buf.readFloat();
        float hitZ = buf.readFloat();
        Supplier entity = Suppliers.memoize(() -> builder.level.m_6815_(id));
        builder.entity((java.util.function.Supplier)entity);
        builder.hit((java.util.function.Supplier)Suppliers.memoize(() -> EntityAccessorImpl.lambda$fromNetwork$2((java.util.function.Supplier)entity, hitX, hitY, hitZ)));
        return builder.build();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showDetails());
        buf.m_130130_(this.entity.get().m_19879_());
        Vec3 hitVec = ((EntityHitResult)this.getHitResult()).m_82450_();
        buf.writeFloat((float)hitVec.f_82479_);
        buf.writeFloat((float)hitVec.f_82480_);
        buf.writeFloat((float)hitVec.f_82481_);
    }

    @Override
    public Entity getEntity() {
        return this.entity.get();
    }

    @Override
    public ItemStack getPickedResult() {
        return CommonProxy.getEntityPickedResult(this.entity.get(), this.getPlayer(), (EntityHitResult)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        if (!data.m_128441_("WailaEntityID")) {
            return false;
        }
        return data.m_128451_("WailaEntityID") == this.getEntity().m_19879_();
    }

    private static /* synthetic */ EntityHitResult lambda$fromNetwork$2(java.util.function.Supplier entity, float hitX, float hitY, float hitZ) {
        return new EntityHitResult((Entity)entity.get(), new Vec3((double)hitX, (double)hitY, (double)hitZ));
    }

    public static class Builder
    implements EntityAccessor.Builder {
        public boolean showDetails;
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private java.util.function.Supplier<EntityHitResult> hit;
        private java.util.function.Supplier<Entity> entity;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(java.util.function.Supplier<EntityHitResult> hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(java.util.function.Supplier<Entity> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = accessor::getHitResult;
            this.entity = accessor::getEntity;
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }
}

