/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.item;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ElytraWingItem
extends Item
implements DyeableLeatherItem,
CustomizableElytraItem {
    public ElytraWingItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> lines, @NotNull TooltipFlag flag) {
        RegistryAccess access = level != null ? level.m_9598_() : null;
        lines.addAll(CustomizationUtils.getElytraWingTooltipLines(stack, flag, access));
    }

    public boolean m_41113_(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null) {
            return false;
        }
        return tag.m_128425_("color", 3);
    }

    public int m_41121_(@NotNull ItemStack stack) {
        if (this.m_41113_(stack)) {
            return Objects.requireNonNull(stack.m_41737_("customizableelytra:customization")).m_128451_("color");
        }
        if (this.hasBanner(stack)) {
            DyeColor baseDyeColor = (DyeColor)this.getBannerPatterns(stack).get(0).getSecond();
            return CustomizationUtils.convertDyeColorToInt(baseDyeColor);
        }
        return 0xFFFFFF;
    }

    public void m_41123_(@NotNull ItemStack stack) {
        stack.m_41698_("customizableelytra:customization").m_128473_("color");
    }

    public void m_41115_(@NotNull ItemStack stack, int color) {
        stack.m_41698_("customizableelytra:customization").m_128405_("color", color);
    }

    @Override
    public boolean isCustomized(@NotNull ItemStack stack) {
        return this.m_41113_(stack) || this.hasBanner(stack) || this.isCapeHidden(stack) || this.isGlowing(stack) || this.hasArmorTrim(stack);
    }

    @Override
    public boolean canDye(@NotNull ItemStack stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean canApplyBanner(@NotNull ItemStack stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean hasBanner(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null) {
            return false;
        }
        return tag.m_128425_("base", 3);
    }

    @Override
    public List<Pair<Holder<BannerPattern>, DyeColor>> getBannerPatterns(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag != null) {
            return BannerBlockEntity.m_58484_((DyeColor)DyeColor.m_41053_((int)tag.m_128451_("base")), (ListTag)tag.m_128437_("patterns", 10));
        }
        return BannerBlockEntity.m_58484_((DyeColor)DyeColor.WHITE, null);
    }

    @Override
    public void setBanner(@NotNull ItemStack stack, @NotNull ItemStack banner) {
        int base = ((BannerItem)banner.m_41720_()).m_40545_().m_41060_();
        ListTag patterns = null;
        CompoundTag blockEntityTag = banner.m_41737_("BlockEntityTag");
        if (blockEntityTag != null) {
            patterns = blockEntityTag.m_128437_("Patterns", 10);
        }
        CompoundTag tag = stack.m_41698_("customizableelytra:customization");
        tag.m_128473_("color");
        tag.m_128405_("base", base);
        if (patterns != null) {
            tag.m_128365_("patterns", (Tag)patterns);
        }
    }

    @Override
    public boolean isGlowing(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null) {
            return false;
        }
        return tag.m_128471_("glowing");
    }

    @Override
    public void setGlowing(@NotNull ItemStack stack, boolean glowing) {
        CompoundTag tag = stack.m_41698_("customizableelytra:customization");
        tag.m_128379_("glowing", glowing);
    }

    @Override
    public boolean isCapeHidden(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null) {
            return false;
        }
        return tag.m_128471_("cape_hidden");
    }

    @Override
    public void setCapeHidden(@NotNull ItemStack stack, boolean capeHidden) {
        CompoundTag tag = stack.m_41698_("customizableelytra:customization");
        tag.m_128379_("cape_hidden", capeHidden);
    }

    @Override
    public boolean hasArmorTrim(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null) {
            return false;
        }
        return tag.m_128425_("trim", 10);
    }

    @Override
    public Optional<ArmorTrim> getArmorTrim(@NotNull ItemStack stack, RegistryAccess registryAccess) {
        CompoundTag tag = stack.m_41737_("customizableelytra:customization");
        if (tag == null || !tag.m_128425_("trim", 10)) {
            return Optional.empty();
        }
        ArmorTrim armorTrim = ArmorTrim.f_265985_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess), (Object)tag.m_128469_("trim")).resultOrPartial(arg_0 -> ((Logger)Constants.LOG).error(arg_0)).orElse(null);
        return Optional.ofNullable(armorTrim);
    }

    @Override
    public void setArmorTrim(@NotNull ItemStack stack, RegistryAccess registryAccess, @NotNull ArmorTrim trim) {
        Tag trimTag = (Tag)ArmorTrim.f_265985_.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess), (Object)trim).result().orElseThrow();
        CompoundTag tag = stack.m_41698_("customizableelytra:customization");
        tag.m_128365_("trim", trimTag);
    }
}

