/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.client;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.mixin.TextureAtlasAccessor;
import com.hidoni.customizableelytra.render.ElytraWingModel;
import com.hidoni.customizableelytra.render.TextureUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;

public class CustomizableElytraLayerHelper<T extends LivingEntity> {
    private static final ResourceLocation TEXTURE_GRAYSCALE_ELYTRA = new ResourceLocation("customizableelytra", "textures/entity/elytra.png");
    private static final Function<ArmorTrim, ResourceLocation> elytraTrimLookup = Util.m_143827_(trim -> ((TrimPattern)trim.m_266429_().m_203334_()).f_266052_().m_247266_(path -> "trims/models/elytra/" + path + "_" + ((TrimMaterial)trim.m_266210_().m_203334_()).f_265854_()));
    private static final ResourceLocation VANILLA_WINGS_LOCATION = new ResourceLocation("textures/entity/elytra.png");
    private T entity = null;
    private MultiBufferSource defaultBuffer = null;
    private ItemStack elytra = null;
    private final TextureAtlas bannerPatternAtlas = CustomizableElytraLayerHelper.getAtlas(Constants.ELYTRA_BANNER_SHEET);
    private final TextureAtlas armorTrimAtlas = CustomizableElytraLayerHelper.getAtlas(Sheets.f_265912_);

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setDefaultBuffer(MultiBufferSource defaultBuffer) {
        this.defaultBuffer = defaultBuffer;
    }

    public void setElytra(ItemStack elytra) {
        this.elytra = elytra;
    }

    public ItemStack getElytra() {
        return this.elytra;
    }

    public void renderWing(ElytraWingModel<T> wingModel, ItemStack wingStack, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, boolean hasFoil) {
        CustomizableElytraItem wingItem = (CustomizableElytraItem)wingStack.m_41720_();
        if (wingItem.isGlowing(wingStack)) {
            packedLight |= 0xFF;
        }
        if (wingItem.m_41113_(wingStack)) {
            this.renderDyedWing(wingModel, wingStack, poseStack, packedLight, wingItem, this.getGrayscaleTexture(wingItem.isCapeHidden(wingStack)), hasFoil);
        } else if (wingItem.hasBanner(wingStack)) {
            this.renderWingBannerPatterns(wingModel, wingStack, poseStack, packedLight, wingItem, this.getGrayscaleTexture(wingItem.isCapeHidden(wingStack)), hasFoil);
        } else {
            this.renderBasicWing(wingModel, wingStack, poseStack, packedLight, wingItem, hasFoil);
        }
        if (wingItem.hasArmorTrim(wingStack)) {
            this.renderWingTrim(wingModel, wingStack, poseStack, packedLight, wingItem, hasFoil);
        }
    }

    private void renderDyedWing(ElytraWingModel<T> wingModel, ItemStack wingStack, PoseStack poseStack, int packedLight, CustomizableElytraItem wingItem, ResourceLocation elytraTexture, boolean hasFoil) {
        VertexConsumer elytraVertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)this.defaultBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)elytraTexture), (boolean)false, (boolean)hasFoil);
        float[] rgb = CustomizationUtils.convertIntToRGB(wingItem.m_41121_(wingStack));
        wingModel.m_7695_(poseStack, elytraVertexConsumer, packedLight, OverlayTexture.f_118083_, rgb[0], rgb[1], rgb[2], 1.0f);
    }

    private void renderWingBannerPatterns(ElytraWingModel<T> wingModel, ItemStack wingStack, PoseStack poseStack, int packedLight, CustomizableElytraItem wingItem, ResourceLocation elytraTexture, boolean hasFoil) {
        List<Pair<Holder<BannerPattern>, DyeColor>> bannerPatterns = wingItem.getBannerPatterns(wingStack);
        wingModel.m_7695_(poseStack, ItemRenderer.m_115222_((MultiBufferSource)this.defaultBuffer, (RenderType)RenderType.m_110482_((ResourceLocation)elytraTexture), (boolean)false, (boolean)hasFoil), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        float[] baseColor = ((DyeColor)bannerPatterns.get(0).getSecond()).m_41068_();
        wingModel.m_7695_(poseStack, ItemRenderer.m_115211_((MultiBufferSource)this.defaultBuffer, (RenderType)RenderType.m_110473_((ResourceLocation)elytraTexture), (boolean)false, (boolean)false), packedLight, OverlayTexture.f_118083_, baseColor[0], baseColor[1], baseColor[2], 1.0f);
        for (int i = 1; i < 17 && i < bannerPatterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> bannerAndColor = bannerPatterns.get(i);
            float[] colors = ((DyeColor)bannerAndColor.getSecond()).m_41068_();
            Optional resourceKey = ((Holder)bannerAndColor.getFirst()).m_203543_();
            if (!resourceKey.isPresent()) continue;
            Material bannerMaterial = new Material(Constants.ELYTRA_BANNER_SHEET, CustomizableElytraLayerHelper.getTextureLocation((ResourceKey<BannerPattern>)((ResourceKey)resourceKey.get())));
            Map<ResourceLocation, TextureAtlasSprite> texturesByName = ((TextureAtlasAccessor)this.bannerPatternAtlas).getTexturesByName();
            if (texturesByName.get(bannerMaterial.m_119203_()) == null) continue;
            wingModel.m_7695_(poseStack, bannerMaterial.m_119194_(this.defaultBuffer, RenderType::m_110473_), packedLight, OverlayTexture.f_118083_, colors[0], colors[1], colors[2], 1.0f);
        }
    }

    private void renderBasicWing(ElytraWingModel<T> wingModel, ItemStack wingStack, PoseStack poseStack, int packedLight, CustomizableElytraItem wingItem, boolean hasFoil) {
        ResourceLocation elytraTexture = null;
        if (!wingItem.isCapeHidden(wingStack)) {
            elytraTexture = this.getCapeTexture();
        }
        if (elytraTexture == null) {
            elytraTexture = VANILLA_WINGS_LOCATION;
        }
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)this.defaultBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)elytraTexture), (boolean)false, (boolean)hasFoil);
        wingModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @NotNull
    private static TextureAtlas getAtlas(ResourceLocation location) {
        return Minecraft.m_91087_().m_91304_().m_119428_(location);
    }

    private void renderWingTrim(ElytraWingModel<T> wingModel, ItemStack wingStack, PoseStack poseStack, int packedLight, CustomizableElytraItem wingItem, boolean hasFoil) {
        Optional<ArmorTrim> armorTrim = wingItem.getArmorTrim(wingStack, this.entity.m_9236_().m_9598_());
        armorTrim.ifPresent(trim -> {
            ResourceLocation trimLocation = elytraTrimLookup.apply((ArmorTrim)trim);
            TextureAtlasSprite sprite = this.armorTrimAtlas.m_118316_(trimLocation);
            VertexConsumer consumer = sprite.m_118381_(ItemRenderer.m_115222_((MultiBufferSource)this.defaultBuffer, (RenderType)Sheets.m_266442_(), (boolean)true, (boolean)hasFoil));
            wingModel.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        });
    }

    private ResourceLocation getGrayscaleTexture(boolean capeHidden) {
        ResourceLocation elytraTexture = null;
        if (!capeHidden) {
            elytraTexture = this.getCapeTexture();
        }
        if (elytraTexture != null) {
            return TextureUtils.getGrayscale(elytraTexture);
        }
        return TEXTURE_GRAYSCALE_ELYTRA;
    }

    private ResourceLocation getCapeTexture() {
        T t = this.entity;
        if (t instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)t;
            if (clientPlayer.m_108562_() && clientPlayer.m_108563_() != null) {
                return clientPlayer.m_108563_();
            }
            if (clientPlayer.m_108555_() && clientPlayer.m_108561_() != null && clientPlayer.m_36170_(PlayerModelPart.CAPE)) {
                return clientPlayer.m_108561_();
            }
        }
        return null;
    }

    private static ResourceLocation getTextureLocation(ResourceKey<BannerPattern> bannerIn) {
        return new ResourceLocation("customizableelytra", "entity/elytra_banner/" + bannerIn.m_135782_().m_135815_());
    }
}

