/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil.AnvilUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class AnvilUpgradeContainer
extends UpgradeContainerBase<AnvilUpgradeWrapper, AnvilUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final Slot resultSlot;
    private PersistableAnvilMenu anvilMenuDelegate;
    private Runnable slotsChangeListener = () -> {};
    private boolean processingOnTakeLogic = false;

    public AnvilUpgradeContainer(Player player, int upgradeContainerId, AnvilUpgradeWrapper upgradeWrapper, UpgradeContainerType<AnvilUpgradeWrapper, AnvilUpgradeContainer> type) {
        super(player, upgradeContainerId, (IUpgradeWrapper)upgradeWrapper, type);
        this.anvilMenuDelegate = new PersistableAnvilMenu(new Inventory(player), upgradeWrapper);
        this.slots.add(this.anvilMenuDelegate.m_38853_(0));
        this.slots.add(this.anvilMenuDelegate.m_38853_(1));
        this.resultSlot = this.anvilMenuDelegate.m_38853_(2);
        this.slots.add(this.resultSlot);
    }

    public void setSlotsChangeListener(Runnable slotsChangeListener) {
        this.slotsChangeListener = slotsChangeListener;
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else if (data.m_128441_("itemName")) {
            this.setItemName(data.m_128461_("itemName"));
        }
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((AnvilUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public boolean isProcessingOnTakeLogic() {
        return this.processingOnTakeLogic;
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((AnvilUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean((CompoundTag)new CompoundTag(), (String)DATA_SHIFT_CLICK_INTO_STORAGE, (boolean)shiftClickIntoStorage));
    }

    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    public boolean allowsPickupAll(Slot slot) {
        return slot != this.resultSlot;
    }

    public void setItemName(String name) {
        this.anvilMenuDelegate.m_39020_(name);
        ((AnvilUpgradeWrapper)this.upgradeWrapper).setItemName(name);
        this.sendDataToServer(() -> NBTHelper.putString((CompoundTag)new CompoundTag(), (String)"itemName", (String)name));
    }

    public int getCost() {
        return this.anvilMenuDelegate.m_39028_();
    }

    @Nullable
    public String getItemName() {
        return this.anvilMenuDelegate.getItemName();
    }

    private class PersistableAnvilMenu
    extends AnvilMenu {
        private final AnvilUpgradeWrapper wrapper;
        private boolean initializing;

        public PersistableAnvilMenu(Inventory playerInventory, AnvilUpgradeWrapper wrapper) {
            super(0, playerInventory, ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)playerInventory.f_35978_.m_20183_()));
            this.initializing = true;
            this.wrapper = wrapper;
            this.f_39769_.m_6836_(0, wrapper.getInventory().getStackInSlot(0));
            this.f_39769_.m_6836_(1, wrapper.getInventory().getStackInSlot(1));
            super.m_39020_(wrapper.getItemName());
            this.initializing = false;
        }

        @Nullable
        public String getItemName() {
            return this.f_39001_;
        }

        public void m_6199_(Container pInventory) {
            super.m_6199_(pInventory);
            if (this.initializing) {
                return;
            }
            this.wrapper.getInventory().setStackInSlot(0, this.f_39769_.m_8020_(0));
            this.wrapper.getInventory().setStackInSlot(1, this.f_39769_.m_8020_(1));
            AnvilUpgradeContainer.this.slotsChangeListener.run();
        }

        protected void m_142365_(Player player, ItemStack stack) {
            AnvilUpgradeContainer.this.processingOnTakeLogic = true;
            super.m_142365_(player, stack);
            AnvilUpgradeContainer.this.processingOnTakeLogic = false;
        }
    }
}

