/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.TranslucentVertexConsumer;

public class BarrelRenderer<T extends BarrelBlockEntity>
extends StorageRenderer<T> {
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.f_82478_);

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        boolean flatTop = Boolean.TRUE.equals(blockEntity.m_58900_().m_61143_((Property)BarrelBlock.FLAT_TOP));
        if (((WoodStorageBlockEntity)blockEntity).isPacked()) {
            return;
        }
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop) {
        if (!(((BarrelBlockEntity)blockEntity).hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || ((StorageBlockEntity)blockEntity).shouldShowUpgrades())) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)BarrelBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(facing));
        poseStack.m_85837_(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
        boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
        if (((StorageBlockEntity)blockEntity).shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
            } else {
                this.displayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(blockEntity));
            }
        }
        if (((BarrelBlockEntity)blockEntity).hasDynamicRenderer()) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            } else {
                this.displayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            }
        }
        poseStack.m_85849_();
    }

    public int m_142163_() {
        return 32;
    }

    protected void renderHiddenTier(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowTier() && this.holdsItemThatShowsHiddenTiers()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getTierQuads);
        }
    }

    protected void renderHiddenLock(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowLock() && ((StorageBlockEntity)blockEntity).isLocked() && this.holdsToolInToggleLockOrLockDisplay()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getLockQuads);
        }
    }

    private void renderTranslucentQuads(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, GetQuadsFunction getQuads) {
        String woodName = ((WoodStorageBlockEntity)blockEntity).getWoodType().orElse(WoodType.f_61833_).f_61839_();
        BlockState state = blockEntity.m_58900_();
        BakedModel blockModel = Minecraft.m_91087_().m_91289_().m_110910_(state);
        poseStack.m_85836_();
        poseStack.m_85837_(-0.005, -0.005, -0.005);
        poseStack.m_85841_(1.01f, 1.01f, 1.01f);
        if (blockEntity.m_58904_() != null && blockModel instanceof BarrelBakedModelBase) {
            BarrelBakedModelBase barrelBakedModel = (BarrelBakedModelBase)blockModel;
            VertexConsumer vertexConsumer = TranslucentVertexConsumer.getVertexConsumer(bufferSource, 128);
            getQuads.apply(barrelBakedModel, state, blockEntity.m_58904_().f_46441_, woodName, RenderType.m_110463_()).forEach(quad -> vertexConsumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay));
        }
        poseStack.m_85849_();
    }

    private static interface GetQuadsFunction {
        public List<BakedQuad> apply(BarrelBakedModelBase var1, BlockState var2, RandomSource var3, String var4, RenderType var5);
    }
}

