/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.contraption;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.PumpjackBearingBBlock;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackHoleBlockEntity;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PumpjackHeadMovementBehaviour
implements MovementBehaviour {
    BlockPos holePos;
    BlockPos headPos;

    @Nullable
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    public boolean isActive(MovementContext context) {
        if (!(context.contraption instanceof BearingContraption)) {
            return false;
        }
        if (((BearingContraption)context.contraption).getFacing().m_122434_() == Direction.Axis.Y || ((Direction)context.state.m_61143_((Property)PumpjackBearingBBlock.FACING)).m_122434_() != ((BearingContraption)context.contraption).getFacing().m_122427_().m_122434_()) {
            return false;
        }
        return context.world.m_7702_(context.contraption.anchor.m_121945_(((BearingContraption)context.contraption).getFacing().m_122424_())) instanceof PumpjackBearingBlockEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockPos hole = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_("HolePos"));
        if (!(context.world.m_7702_(hole) instanceof PumpjackHoleBlockEntity)) {
            return;
        }
        PumpjackBearingBlockEntity bearing = null;
        BlockEntity blockEntity = context.world.m_7702_(context.contraption.anchor.m_121945_(((BearingContraption)context.contraption).getFacing().m_122424_()));
        if (blockEntity instanceof PumpjackBearingBlockEntity) {
            PumpjackBearingBlockEntity be;
            bearing = be = (PumpjackBearingBlockEntity)blockEntity;
        }
        if (bearing == null) {
            return;
        }
        SuperByteBuffer cover = CachedBufferer.partial((PartialModel)PartialModels.PUMPJACK_ROPE, (BlockState)context.state);
        if (((BearingContraption)context.contraption).getFacing().m_122424_().m_122434_() == Direction.Axis.X) {
            double zDst = context.position.f_82481_ - (double)hole.m_123343_() - 0.5;
            double yDst = context.position.f_82480_ - (double)hole.m_123342_() - (double)0.8f;
            float distanceFromHole = (float)Math.sqrt(zDst * zDst + yDst * yDst);
            double angle = (double)(-((ControlledContraptionEntity)context.contraption.entity).getAngle(AnimationTickHolder.getPartialTicks())) - 180.0 * Math.atan2(yDst, zDst) / Math.PI + 90.0;
            PoseStack ms = matrices.getModel();
            ((SuperByteBuffer)cover.transform(ms).translate(0.5, 0.5, 0.5).rotateX(angle)).scale(1.0f, distanceFromHole, 1.0f).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight((MovementContext)context, (VirtualRenderWorld)renderWorld)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110457_()));
            return;
        }
        double xDst = context.position.f_82479_ - (double)hole.m_123341_() - 0.5;
        double yDst = context.position.f_82480_ - (double)hole.m_123342_() - (double)0.8f;
        float distanceFromHole = (float)Math.sqrt(xDst * xDst + yDst * yDst);
        double angle = (double)(-((ControlledContraptionEntity)context.contraption.entity).getAngle(AnimationTickHolder.getPartialTicks())) + 180.0 * Math.atan2(yDst, xDst) / Math.PI - 90.0;
        PoseStack ms = matrices.getModel();
        ((SuperByteBuffer)cover.transform(ms).translate(0.5, 0.5, 0.5).rotateZ(angle)).scale(1.0f, distanceFromHole, 1.0f).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight((MovementContext)context, (VirtualRenderWorld)renderWorld)).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110457_()));
    }

    public void tick(MovementContext context) {
        super.tick(context);
        PumpjackBearingBlockEntity bearing = null;
        BlockEntity blockEntity = context.world.m_7702_(context.contraption.anchor.m_121945_(((BearingContraption)context.contraption).getFacing().m_122424_()));
        if (blockEntity instanceof PumpjackBearingBlockEntity) {
            PumpjackBearingBlockEntity be;
            bearing = be = (PumpjackBearingBlockEntity)blockEntity;
        }
        if (bearing == null) {
            return;
        }
        this.holePos = this.headPos = new BlockPos(context.contraption.anchor.m_123341_() + context.localPos.m_123341_(), context.contraption.anchor.m_123342_() + context.localPos.m_123342_(), context.contraption.anchor.m_123343_() + context.localPos.m_123343_());
        for (int i = 0; i < 32; ++i) {
            BlockEntity blockEntity2 = context.world.m_7702_(this.holePos);
            if (blockEntity2 instanceof PumpjackHoleBlockEntity) {
                PumpjackHoleBlockEntity phbe = (PumpjackHoleBlockEntity)blockEntity2;
                break;
            }
            this.holePos = this.holePos.m_7495_();
        }
        if ((blockEntity = context.world.m_7702_(this.holePos)) instanceof PumpjackHoleBlockEntity) {
            PumpjackHoleBlockEntity holeBE = (PumpjackHoleBlockEntity)blockEntity;
            if (bearing.crankSpeed >= 8.0f) {
                holeBE.headPos = ((Direction)bearing.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == Direction.Axis.X ? context.localPos.m_123343_() : context.localPos.m_123341_();
                int n = holeBE.bearingPos = ((Direction)bearing.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == Direction.Axis.X ? bearing.bearingBPos.m_123343_() : bearing.bearingBPos.m_123341_();
                if ((bearing.crankAngle + 180.0f) % 360.0f < (context.data.m_128457_("OldCrankAngle") + 180.0f) % 360.0f) {
                    holeBE.tickFluid(bearing.isLarge);
                }
            }
        }
        context.data.m_128350_("OldCrankAngle", bearing.crankAngle);
        context.data.m_128365_("HolePos", (Tag)NbtUtils.m_129224_((BlockPos)this.holePos));
    }
}

