/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class NoShaftBearingInstance<B extends KineticBlockEntity>
extends BlockEntityInstance<B>
implements DynamicInstance {
    final OrientedData topInstance;
    final Axis rotationAxis;
    final Quaternionf blockOrientation;

    public NoShaftBearingInstance(MaterialManager materialManager, B blockEntity) {
        super(materialManager, blockEntity);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Axis.m_253057_((Vector3f)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction)blockEntity.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_()).m_253071_());
        this.blockOrientation = NoShaftBearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingBlockEntity)((KineticBlockEntity)this.blockEntity)).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternionf rot = this.rotationAxis.m_252977_(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.topInstance});
    }

    public void remove() {
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(Direction facing) {
        Quaternionf orientation = facing.m_122434_().m_122479_() ? Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)facing.m_122424_())) : new Quaternionf();
        orientation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-90.0f - AngleHelper.verticalAngle((Direction)facing)));
        return orientation;
    }
}

