/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HugeDieselEngineInstance
extends BlockEntityInstance<HugeDieselEngineBlockEntity>
implements DynamicInstance {
    protected final ModelData piston = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON).createInstance();
    protected final ModelData connector = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON_CONNECTOR).createInstance();
    protected final ModelData linkage = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON_LINKAGE).createInstance();

    public HugeDieselEngineInstance(MaterialManager materialManager, HugeDieselEngineBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
    }

    public void beginFrame() {
        float shaftR;
        boolean roll90;
        Float angle = ((HugeDieselEngineBlockEntity)this.blockEntity).getTargetAngle();
        BlockState state = ((HugeDieselEngineBlockEntity)this.blockEntity).m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING);
        Direction.Axis facingAxis = facing.m_122434_();
        if (angle == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        PoweredEngineShaftBlockEntity shaft = ((HugeDieselEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        boolean bl = roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float f = facing == Direction.DOWN ? -90.0f : (facing == Direction.UP ? 90.0f : (facing == Direction.WEST ? -90.0f : (shaftR = facing == Direction.EAST ? 90.0f : 0.0f)));
        if (roll90) {
            shaftR = facing == Direction.NORTH ? 180.0f : (facing == Direction.SOUTH ? 0.0f : (facing == Direction.EAST ? -90.0f : (facing == Direction.WEST ? 90.0f : 0.0f)));
        }
        angle = Float.valueOf(angle.floatValue() + (float)((double)shaftR * Math.PI / 180.0));
        float sine = Mth.m_14031_((float)angle.floatValue()) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f)) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float pistonOffset = (1.0f - sine) / 4.0f + 0.4375f;
        this.transformed(this.piston, facing, roll90).translate(0.0, (double)pistonOffset, 0.0);
        ((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)pistonOffset, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5);
        if (shaft.isEngineForConnectorDisplay(((HugeDieselEngineBlockEntity)this.blockEntity).m_58899_())) {
            ((ModelData)((ModelData)this.transformed(this.connector, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f) - (facingAxis.m_122478_() ? Math.PI : 0.0))).unCentre();
        } else {
            this.connector.setEmptyTransform();
        }
    }

    protected ModelData transformed(ModelData modelData, Direction facing, boolean roll90) {
        return (ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX((double)(AngleHelper.verticalAngle((Direction)facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.piston, this.connector, this.linkage});
    }

    protected void remove() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

