/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import com.mrcrayfish.configured.impl.forge.ForgeConfig;
import com.mrcrayfish.configured.util.ForgeConfigHelper;
import com.mrcrayfish.configured.util.OptiFineHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigProvider
implements IModConfigProvider {
    @Override
    public Set<IModConfig> getConfigurationsForMod(ModContext context) {
        HashSet<IModConfig> configs = new HashSet<IModConfig>();
        ForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.CLIENT, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.COMMON, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.SERVER, configs::add);
        return configs;
    }

    private static void addForgeConfigSetToMap(ModContext context, ModConfig.Type type, Consumer<IModConfig> consumer) {
        if (type == ModConfig.Type.CLIENT && OptiFineHelper.isLoaded() && context.modId().equals("forge")) {
            Constants.LOG.info("Ignoring Forge's client config since OptiFine was detected");
            return;
        }
        for (ModConfig config : (Set)ConfigTracker.INSTANCE.configSets().get(type)) {
            ForgeConfigSpec spec;
            if (!config.getModId().equals(config.getModId()) || (spec = ForgeConfigHelper.findConfigSpec((UnmodifiableConfig)config.getSpec())) == null) continue;
            consumer.accept(new ForgeConfig(config, spec));
        }
    }
}

