/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.forge;

import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidTankImpl;

public class AmendmentsPlatformStuffImpl {
    public static SoftFluidTank createCauldronLiquidTank(final BooleanSupplier canMix) {
        return new SoftFluidTankImpl(4){

            public boolean canAddSoftFluid(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)BuiltInSoftFluids.WATER.get())) {
                    return false;
                }
                if (canMix.getAsBoolean() && fluidStack.is((SoftFluid)BuiltInSoftFluids.POTION.get()) && fluidStack.is(this.getFluidValue())) {
                    return this.getSpace() >= fluidStack.getCount() && this.fluid.getTag().m_128461_("Bottle").equals(fluidStack.getTag().m_128461_("Bottle"));
                }
                return super.canAddSoftFluid(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                if (canMix.getAsBoolean() && incoming.is((SoftFluid)BuiltInSoftFluids.POTION.get())) {
                    LiquidMixer.mixPotions(this.fluid, incoming);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public static SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTankImpl(3){

            public boolean canAddSoftFluid(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get()) && fluidStack.is(this.getFluidValue())) {
                    return this.getSpace() >= fluidStack.getCount();
                }
                return super.canAddSoftFluid(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                if (fluidStack.is((SoftFluid)ModRegistry.DYE_SOFT_FLUID.get())) {
                    LiquidMixer.mixDye(this.fluid, fluidStack);
                }
                super.addFluidOntoExisting(fluidStack);
            }
        };
    }
}

