/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.AmendmentsPlatformStuff;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LiquidCauldronBlockTile
extends BlockEntity
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<SoftFluid> FLUID = new ModelDataKey(SoftFluid.class);
    private final SoftFluidTank fluidTank;

    public SoftFluidTank makeTank(BlockState blockState) {
        return blockState.m_60734_() instanceof DyeCauldronBlock ? AmendmentsPlatformStuff.createCauldronDyeTank() : AmendmentsPlatformStuff.createCauldronLiquidTank(this::canMixPotions);
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.m_58900_().m_61143_((Property)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(BlockPos blockPos, BlockState blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(FLUID, (Object)this.fluidTank.getFluidValue()).build();
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.fluidTank.load(compound);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidTank.save(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)block;
            state = cb.updateStateOnFluidChange(state, this.f_58857_, this.f_58858_, this.fluidTank.getFluid());
        }
        if (state != this.m_58900_()) {
            this.f_58857_.m_46597_(this.f_58858_, state);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), state, 2);
        super.m_6596_();
    }

    public boolean handleInteraction(Player player, InteractionHand hand) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.f_58857_, this.f_58858_)) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.m_6596_();
    }
}

