/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.CarpetSlabBlock;
import net.mehvahdjukaar.amendments.common.block.CarpetStairBlock;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CarpetedBlockTile
extends MimicBlockTile {
    private static final Map<Pair<SoundType, SoundType>, SoundType> MIXED_SOUND_MAP = new HashMap<Pair<SoundType, SoundType>, SoundType>();
    public static final ModelDataKey<BlockState> CARPET_KEY = new ModelDataKey(BlockState.class);
    private BlockState carpet = Blocks.f_50336_.m_49966_();
    private SoundType soundType = null;

    public CarpetedBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.CARPET_STAIRS_TILE.get(), pos, state);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(MIMIC_KEY, (Object)this.mimic).with(CARPET_KEY, (Object)this.carpet).build();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        HolderLookup.RegistryLookup holderGetter = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        this.setCarpet(NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)compound.m_128469_("Carpet")));
    }

    public void setCarpet(BlockState carpet) {
        this.setHeldBlock(carpet, 1);
    }

    public BlockState getCarpet() {
        return this.getHeldBlock(1);
    }

    public BlockState getSlab() {
        return this.getHeldBlock();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Carpet", (Tag)NbtUtils.m_129202_((BlockState)this.carpet));
    }

    public BlockState getHeldBlock(int index) {
        if (index == 1) {
            return this.carpet;
        }
        return super.getHeldBlock(index);
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (index == 0) {
            this.mimic = state;
            if (this.f_58857_ instanceof ServerLevel) {
                this.m_6596_();
                int newLight = this.getLightValue();
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)this.m_58900_().m_61124_((Property)CarpetStairBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight))).m_61124_((Property)CarpetSlabBlock.SOLID, (Comparable)Boolean.valueOf(state.m_60815_())), 3);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            } else {
                this.requestModelReload();
            }
            return true;
        }
        if (index == 1) {
            this.carpet = state;
            return true;
        }
        this.soundType = null;
        return false;
    }

    public void initialize(BlockState stairs, BlockState carpet) {
        this.setHeldBlock(carpet, 1);
        this.setHeldBlock(stairs, 0);
    }

    public int getLightValue() {
        return this.getHeldBlock().m_60791_();
    }

    @Nullable
    public SoundType getSoundType() {
        if (this.soundType == null) {
            BlockState stairs = this.getHeldBlock();
            BlockState carpet = this.getHeldBlock(1);
            if (!stairs.m_60795_() && !carpet.m_60795_()) {
                SoundType stairsSound = stairs.m_60827_();
                SoundType carpetSound = carpet.m_60827_();
                this.soundType = MIXED_SOUND_MAP.computeIfAbsent((Pair<SoundType, SoundType>)Pair.of((Object)stairsSound, (Object)carpetSound), p -> new SoundType(1.0f, 1.0f, stairsSound.m_56775_(), carpetSound.m_56776_(), stairsSound.m_56777_(), stairsSound.m_56778_(), carpetSound.m_56779_()));
            } else {
                return null;
            }
        }
        return this.soundType;
    }
}

